package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 客户权益管理-> 额度申请表
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
public class OperateQuotaApply extends UserTimeEntity {

    /**
     * 申请单编码
     */
    @UniqueField
    private String code;

    /**
     * 申请单名称
     */
    private String name;

    /**
     * 申请方式:整体或分团队或 分主体
     *
     * @see OperationConstant.DictQuotaApplyWay
     */
    private String applyWay;

    /**
     * 申请单状态
     *
     * @see OperationConstant.DictQuotaApplyStatus
     */
    private String status;

    /**
     * 申请人用户id: reference basic_system_admin_user.id
     */
    private Integer applierUserId;

    /**
     * 申请人用户名: reference basic_system_admin_user.username
     */
    private String applierUser;

    /**
     * 申请人手机号:reference basic_system_admin_user.mobile
     */
    private String applierMobile;

    /**
     * 申请人名字: reference basic_system_admin_user.name
     */
    private String applierName;

    /**
     * 审批进度：当前待审批人用户名, 如果审批不通过,审批完毕了，则设置为空串
     */
    private String curApproverUser;

    /**
     * 审批进度：当前审批节点类型,即审批业务类型
     *
     * @see QuotaApproveNodeTypeEnum
     */
    private String curNodeType;

    /**
     * 申请人的 发放主体编号: reference equity_issuing_body.code
     */
    private String issuingBodyCode;

    /**
     * 申请人发放主体的祖先主体编号
     */
    private String topIssuingBodyCode;

    /**
     * 申请额度
     */
    private Integer quota;

    //额度转换备付金 兑换比例
    private BigDecimal quotaConversionRatio;

    /**
     * 代理商编号：如果发放主体是代理商
     * 如果发放主体的quity_issuing_body.whether_customer='AGENT'
     */
    private String agentCode;

    /**
     * 合作客户编号：如果发放主体的 equity_issuing_body.whether_customer='CUSTOMER'
     */
    private String customerCode;


    /**
     * 团队/发放主体 数量【团队/发放主体 申请方式专属字段】
     */
    private Integer teamNum;

    /**
     * 最近的操作: 如 审核、审批、处理
     */
    private QuotaApproveNodeTypeEnum recentAction;

    /**
     * 最近操作时间：审核时间,完成时间
     */
    private LocalDateTime recentActionTime;

    /**
     * 最近操作人用户名
     */
    private String recentActionUser;

    //当前审批人名字
    private transient String curApproverName;

    /**
     * 是否允许修改
     *
     * @return
     */
    public boolean isModifyAllowed() {
        return OperationConstant.DictQuotaApplyStatus.AUDIT_FAILED.equals(status) ||
                OperationConstant.DictQuotaApplyStatus.APPROVE_FAILED.equals(status);
    }


    /**
     * 申请是否可以审批
     */
    public boolean isApproveble() {
        return OperationConstant.DictQuotaApplyStatus.PENDING_AUDIT.equals(status) ||
                OperationConstant.DictQuotaApplyStatus.PENDING_APPROVE.equals(status);
    }


    /**
     * 需要充值的备付金:  coverQuota = quota *（合作客户或代理商）配置的额度转换系数
     */
    public BigDecimal calcCoverQuota() {
        BigDecimal converQuota = quotaConversionRatio.multiply(new BigDecimal(quota).setScale(3, BigDecimal.ROUND_HALF_UP));
        return converQuota;
    }


    /**
     * 是否是最顶级发放主体
     */
    public boolean isTopLevelIssuingBody() {
        return this.issuingBodyCode.equals(topIssuingBodyCode);
    }


    //包含的团队/发放主体Item
    @TableField(exist = false)
    private List<OperateQuotaApplyItem> teamItemList;

    //审批记录
    @TableField(exist = false)
    private List<OperateQuotaApplyApproveRecord> approveRecordList;


    //该申请单实例 运行时 所有待审核的节点
    @TableField(exist = false)
    private List<OperateQuotaApplyRuntimeNode> pendingApproveNodeList;

    //===== 以下是 非持久化属性 =====
    //发放主体名称,页面显示使用
    private transient String issuingBodyName;

    //是否能被 当前登录用户 审核/审批 【后台申请单列表,判定是否能被登录用户审批使用】
    private transient Boolean approvebleByLoginUser;

    //是否能被 当前登录用户执行划拨操作 【申请单列表,判定登录用户是否有"划拨额度"操作权限】
    private transient Boolean hasAppropriatePerm;

}
