package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 运营模板消息表
 *
 * @author luoyingchang
 * @since 2020-06-10
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("operate_msg_template")
public class OperateMsgTemplate extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 模板编号
     */
    private String templateCode;

    /**
     * 模板标题
     */
    private String templateTitle;

    /**
     * 模板类型
     */
    private String templateType;

    /**
     * 模板内容关键词变量
     */
    private String templateKeys;

    /**
     * 模板内容
     */
    private String templateContent;

    /**
     * 模板状态
     */
    private String status;

    /**
     * 短信编码
     */
    private String smsCode;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 标签名
     */
    private String signName;


}
