package com.rocogz.syy.operation.entity.car.dealer;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 裂变种子关系entity
 * @date：2022/12/08
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("operate_fission_relation")
public class OperateFissionRelation extends IdEntity {

    private static final long serialVersionUID = 489463979153561184L;

    /**
    * 上级种子code
    */
    private String parentFissionSeedCode;
    
    /**
    * 种子code
    */
    @NotBlank(message = "种子编号不能为空")
    private String fissionSeedCode;
    
    /**
    * 种子关系类型（字典，字典编号：SEED_RELATION_TYPE）
    */
    @NotBlank(message = "关系类型不能为空")
    private String seedRelationType;
    
    /**
    * 介绍下级种子年份
    */
    private String introduceYear;
    
    /**
    * 介绍下级种子月份
    */
    private String introduceMonth;
    
    /**
    * 介绍下级种子日期
    */
    private LocalDate introduceDate;
    
    /**
    * 关系说明
    */
    private String relationDescription;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;

    /**
     * 种子信息
     */
    @TableField(exist = false)
    private OperateFissionSeed fissionSeed;
}