package com.rocogz.syy.operation.constants;

/**
 * 运营中心基础服务，常量类
 * @author zhangmin
 * @date 2020/4/3
 */
public class OperationConstant {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String MAX_TIME_SUFFIX = " 23:59:59";

    /**
     * 运营中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "operation-base-service";

    public static class DictData {
        /** 普通消息 */
        public final static String MESSAGE = "MESSAGE";
        /** 短信消息 */
        public final static String SMS = "SMS";
        /** 注册推荐码类型 */
        public static final String REGISTER_IIUV_TYPE = "REGISTER_IIUV_TYPE";
        /** 推荐码商户类型 */
        public static final String REGISTER_IIUV_TYPE_MD = "MD";
        /** 推荐码个人类型 */
        public static final String REGISTER_IIUV_TYPE_SP = "SP";

        /** 通用的是 */
        public static final String COMMON_YES = "Y";
        /** 通用的否 */
        public static final String COMMON_NO = "N";

        /** 注册推荐码 小程序配置信息 */
        public static final String IIUV = "IIUV";
    }

    public static class DataStatus {
        /** status 正常状态 */
        public static final String NORMAL = "NORMAL";
        /** status 锁定状态 */
        public static final String LOCK = "LOCK";
    }

    /**
     * 审批结果
     */
    public static class DictApproveResult {

        //审核通过
        public static String PASS = "PASS";

        //审核不通过
        public static String FAILED = "FAILED";
    }

    //审核的业务回调状态
    public static class ApproveCallBackStatus {

        //成功
        public static String CALLBACK_SUCCESS = "SUCCESS";

        //失败
        public static String CALLBACK_FAIL = "FAIL";
    }

    //需要审核的业务模块
    public static class ApproveBusinessType {

        //字典类型编号
        public static String TYPE_CODE = "approveBusiness";

        //商品模块
        public static String MERCHANT = "merchant";

        //订单模块
        public static String SALE_ORDER = "saleOrder";

        //订单模块
        public static String GOODS = "goods";

        //推广模块
        public static String POPULARIZE_APPLY = "popularizeApply";
    }

    //审批->商品模块->需要审核的项目
    public static class ApproveMerchantItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.MERCHANT;

        //商户模块下的 门店上架 审核项目编号
        public static String STORE_LIST = "STORE_LIST";
        public static String STORE_DELIST = "STORE_DELIST";

        // 商户模块下的 商品上架  审核项目编号
        public static String GOODS_LIST = "GOODS_LIST";
    }

    //审批->销售订单模块->需要审核的项目
    public static class ApproveSaleOrderItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.SALE_ORDER;
        // 提现订单审核
        public static String WITHDRAWALS_APPROVE = "WITHDRAWALS_APPROVE";

       //下面是订单模块的 审核项目编号

    }

    //审批->推广模块->需要审核的项目
    public static class ApprovePopularizeApplyItems {
        // 推广申请审核
        public static String POPULARIZE_APPLY_APPROVE = "POPULARIZE_APPLY_APPROVE";
    }


    //栏目服务
    public static class ColumnService {

        //服务分类
        public static String SERVICE_TYPE = "SERVICE";
    }


    /**
     * 二维码关联的 推荐码/跳转路径 标示类型
     */
    public static class DictOperateQrRelationType{

        /**
         * 推荐码标示
         */
        public final static String TYPE_IIUV="IIUV";

        /**
         * 跳转路径标示
         */
        public final static String TYPE_JUMP="JUMP";



    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /** 意见反馈编号 */
        public final static String OPINION_TYPE = "OPINION_TYPE";
        /** 系统信息编码 */
        public final static String SYSTEM_MESSAGE_CODE = "SYSTEM_MESSAGE_CODE";
    }

    /**
     * 附件类型
     */
    public class AttechmentType {
        /** 意见反馈类型 */
        public final static String OPINION_TYPE = "OPINION_TYPE";
    }

    /**
     * 意见反馈来源值
     */
    public class OpinionSource {
        /** 车主端 */
        public final static String CAR = "CAR";
        /** 商户端 */
        public final static String BUSINESS = "BUSINESS";
        /** 商城端 */
        public final static String ROCO_MALL = "ROCO_MALL";
        /** 代理人端 */
        public final static String AGENT = "AGENT";
        /** 权益配置管理系统端 */
        public final static String EQUITY_MANAGER = "EQUITY_MANAGER";
    }

    /**
     * 运营中心字典类型
     */
    public class DictType {
        /** 消息模板类型 */
        public final static String OPERATE_MSG_TEMPLATE_TYPE = "OPERATE_MSG_TEMPLATE_TYPE";
        /** 意见来源' */
        public final static String OPINION_SOURCE = "OPINION_SOURCE";
        /** 意见类型 */
        public final static String OPINION_TYPE = "OPINION_TYPE";
    }

    /**
     * 运营中心redisKey前缀
     */
    public class RedisKeyPrefix {
        /** 意见次数 */
        public final static String OPINION_NUM = "OPINION_NUM:";
    }

    /**
     * 首页版本推荐类型
     */
    public class recommendType {
        /** 商户 */
        public final static String MERCHANT = "MERCHANT";
        /** 商品 */
        public final static String GOODS = "GOODS";
        /** 推荐油站端 */
        public final static String OIL = "OIL";
    }

    /**
     * 系统端分类
     */
    public class systemEnd {
        /** 车主端 */
        public final static String CAR = "CAR";
        /** 代理人端 */
        public final static String AGENT = "AGENT";
    }


    /**
     * 栏目分类
     */
    public static class Classify {

        //首页栏目
        public static String INDEX = "INDEX";

        //积分栏目
        public static String POINTS = "POINTS";
    }


    /**
     * 客户权益管理-> 额度申请-> 额度申请方式
     */
    public static class DictQuotaApplyWay {

        //字典类型编号
        public static String TYPE_CODE = "QUOTA_APPLY_WAY";

        //整体申请
        public static String ALL = "ALL";

        //分团队申请
        public static String TEAM = "TEAM";

        //分主体申请
        public static String ISSUING_BODY = "ISSUING_BODY";
    }


    /**
     * 客户权益管理-> 额度申请-> 额度申请状态
     */
    public static class DictQuotaApplyStatus {
        //字典类型编号
        public static String TYPE_CODE = "QUOTA_APPLY_STATUS";

        //待审核
        public static final String PENDING_AUDIT = "PENDING_AUDIT";

        //待审批
        public static final String PENDING_APPROVE = "PENDING_APPROVE";

        //待划拨
        public static final String PENDING_ALLOCATE = "PENDING_ALLOCATE";

        //划拨处理中
        public static final String PROCESSING = "PROCESSING";

        //已划拨
        public static final String FINISHED = "FINISHED";

        //审核不通过
        public static final String AUDIT_FAILED = "AUDIT_FAILED";

        //审批不通过
        public static final String APPROVE_FAILED = "APPROVE_FAILED";
    }

    /**
     * 销售线索推进情况、转化情况
     */
    public static class SaleClew {

        /**
         * 线索推进情况字典类型type code
         */
        public static final String ADVANCE_STATUS_DICT_TYPE_CODE = "CLEW_ADVANCE_STATUS_TYPE";

        /**
         * 线索推进情况-未开始
         */
        public static final String ADVANCE_STATUS_NOT_START = "NOT_START";

        /**
         * 线索推进情况-推进中
         */
        public static final String ADVANCE_STATUS_IN_PROGRESS = "IN_PROGRESS";

        /**
         * 线索推进情况-已关闭
         */
        public static final String ADVANCE_STATUS_OFF = "OFF";

        /**
         * 线索转换情况字典类型type code
         */
        public static final String CONVERSION_STATUS_DICT_TYPE_CODE = "CLEW_CONVERSION_STATUS_TYPE";

        /**
         * 线索转换情况-未开始
         */
        public static final String CONVERSION_STATUS_NOT_START = "NOT_START";

        /**
         * 线索转换情况-推进中
         */
        public static final String CONVERSION_STATUS_IN_PROGRESS = "IN_PROGRESS";

        /**
         * 线索转换情况-转化成功
         */
        public static final String CONVERSION_STATUS_CONVERSION_SUCCESS = "CONVERSION_SUCCESS";

        /**
         * 线索转换情况-转化失败
         */
        public static final String CONVERSION_STATUS_CONVERSION_FAil = "CONVERSION_FAil";
    }

    public static class InterActiveRecord {

        /**
         * 交互类型字典类型type code
         */
        public static final String INTERACTIVE_TYPE_DICT_TYPE_CODE = "INTERACTIVE_TYPE";

        /**
         * 交互所属阶段字典类型type code
         */
        public static final String INTERACTIVE_STAGE_DICT_TYPE_CODE = "INTERACTIVE_STAGE_TYPE";
    }

    public static class FissionSeedRelation {

        /**
         * 种子关系类型type code
         */
        public static final String SEED_RELATION_DICT_TYPE_CODE = "SEED_RELATION_TYPE";
    }




    /**
     * 配置的 调查问券状态
     */
    public static final class DictInverstStatus {

        public static final String TYPE_CODE = "OPERATE_INVESTIGATION_STATUS";

        /**
         * 已上架
         */
        public final static String  UP_LIST = "UP_LIST";

        /**
         * 已下架
         */
        public final static String  DOWN_LIST = "DOWN_LIST";


    }
}
