package com.rocogz.syy.operation.dto;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.Map;

@Data
public class OperateMsgTemplateDto {

    /**
     * 发送来源编码
     */
    private String sendSourceCode;

    /**
     * 消息接收者用户Code
     */
    private String userCode;

    /**
     * 消息发送者用户Code
     */
    private String senderCode;

    /**
     * 消息发送者用户姓名
     */
    private String senderName;

    /**
     * 模板code
     */
    private String templateCode;

    /**
     * 接受短信手机号
     */
    private String phone;

    /**
     * 参数<K, V>
     */
    private Map<String, Object> paramsMap;

    /**
     * 父业务编码
     * 2021-03-24新增，用于记录[批量发券的业务单号]
     */
    private String parentBizCode;

    /**
     * 业务编码
     */
    private String bizCode;

    /**
     * 定时执行时间
     */
    private LocalDateTime executeTime;

}
