package com.rocogz.syy.operation.dto.quotapply;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 额度申请 审批进度 返回的dto
 *
 * @author zhangmin
 */
@Setter
@Getter
public class QuotaApplyCurProcessDto {

    //本次审批/审核 是否通过
    private Boolean approvePass;

    /**
     * 申请单号
     */
    private String applyCode;

    /**
     * 申请人用户名
     */
    private String applierUser;

    /**
     * 审批人名字
     */
    private String applierName;

    /**
     * 额度申请时间
     */
    private LocalDateTime createTime;

    /**
     * 申请的额度金额
     */
    private Integer quota;

    /**
     * 审批进度：当前待审批人用户名,如果没有设置审批结点，则没有审批人，因为创建的申请单可以不设置成不需要审批
     */
    private String curApproverUser;

    /**
     * 当前审批人 名字
     */
    private String curApproverName;

    /**
     * 审批进度：当前审批节点类型,即审批业务类型
     *
     * @see QuotaApproveNodeTypeEnum
     */
    private String curNodeType;


    /**
     * 额度申请单：当前状态
     */
    private String applyStatus;


    //审批时间
    private LocalDateTime approvedTime;


    //审批人名字
    private String approvedName;


    /**
     * 划拨操作 用户Id
     */
    private List<Integer> transferUserIdList;

}
