package com.rocogz.syy.operation.entity.car.dealer;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 裂变种子履历entity
 * @date：2022/12/08
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("operate_fission_seed_resume")
public class OperateFissionSeedResume extends IdEntity {

    private static final long serialVersionUID = 785508462263311909L;

    /**
    * 裂变种子code
    */
    private String fissionSeedCode;
    
    /**
    * 所属4S店集团code
    */
    private String blocCode;
    
    /**
    * 所属4S店code
    */
    @NotBlank(message = "所属4S店不能为空")
    private String shopCode;
    
    /**
    * 工作岗位
    */
    @NotBlank(message = "工作岗位不能为空")
    private String job;
    
    /**
    * 在店工作年限
    */
    @NotBlank(message = "在店工作年限不能为空")
    private String serviceYear;
    
    /**
    * 负责业务情况
    */
    @NotBlank(message = "负责业务情况不能为空")
    private String responsibleBusiness;
    
    /**
    * 说明
    */
    private String description;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;

    /**
     * 所属4S店集团简称
     */
    @TableField(exist = false)
    private String blocName;

    /**
     * 所属4S店业内名称
     */
    @TableField(exist = false)
    private String shopName;

    /**
     * 添加人姓名
     */
    @TableField(exist = false)
    private String createUserName;
}