package com.rocogz.syy.operation.entity.car.dealer;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 交互动作记录entity
 * @date：2022/12/08
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("operate_interactive_record")
public class OperateInteractiveRecord extends IdEntity {

    private static final long serialVersionUID = -61946792362955913L;

    /**
    * 编号
    */
    private String code;
    
    /**
    * 4S店集团code
    */
    private String blocCode;

    /**
    * 4S店code
    */
    private String shopCode;

    /**
    * 销售线索code
    */
    private String saleClewCode;

    /**
     * 交互年份
     */
    private String interactiveYear;

    /**
     * 交互月份
     */
    private String interactiveMonth;

    /**
    * 交互日期
    */
    private LocalDate interactiveDate;

    /**
    * 交互开始时间
    */
    private String interactiveStartTime;

    /**
    * 交互结束时间
    */
    private String interactiveEndTime;

    /**
    * 交互时长（小时）
    */
    private BigDecimal interactiveDuration;

    /**
    * 交互形式（常量：PHONE-电话沟通、WECHAT-微信沟通、EMAIL-邮件沟通、INTERVIEW-见面沟通、OHTER-其他）
    */
    private String interactiveWay;

    /**
    * 交互类型（字典常量，字典编号：INTERACTIVE_TYPE）
    */
    private String interactiveType;

    /**
    * 交互主题
    */
    private String interactiveTopic;

    /**
    * 是否在店里交互（常量：Y-是、N-否）
    */
    private String interactiveInStore;

    /**
    * 具体交互地点
    */
    private String interactiveAddress;

    /**
    * 交互时业务上线情况（常量：ONLINE-已上线、OFFLINE-未上线）
    */
    private String businessOnline;

    /**
    * 交互所属阶段（字典常量，字典编号：INTERACTIVE_STAGE_TYPE）
    */
    private String interactiveStage;

    /**
    * 我方交互人姓名
    */
    private String interviewerName;

    /**
     * 交互动作登记年
     */
    private String createYear;

    /**
     * 交互动作登记月
     */
    private String createMonth;

    /**
     * 交互动作登记日期
     */
    private LocalDate createDate;

    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createUsername;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;

    /**
     * 交互动作记录附加信息
     */
    @TableField(exist = false)
    private OperateInteractiveRecordExt recordExt;

    /**
     * 交互对象
     */
    @TableField(exist = false)
    private List<OperateInteractiveObject> interactiveObjects;

    /**
     * 所属4S店集团店
     */
    @TableField(exist = false)
    private OperateCarDealerBloc bloc;

    /**
     * 所属4S店
     */
    @TableField(exist = false)
    private OperateCarDealerShop shop;

}