package com.rocogz.syy.operation.entity.qr;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 推荐码管理
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-28
 */
@Data
@Accessors(chain = true)
@TableName("operate_iiuv")
public class OperateIiuv extends UserTimeEntity {


    private static final long serialVersionUID = 3777516957974052336L;
    /**
     * 推荐码
     */
    private String iiuvCode;

    /**
     * 推荐名称
     */
    private String iiuvName;

    /**
     * 推荐类型
     */
    private String iiuvType;

    /**
     * 推荐类型对应目标的编码
     */
    private String iiuvTargetCode;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 用户openId
     */
    private String openId;

    /**
     * 商户名称
     */
    @TableField(exist = false)
    private String storeName;
}
