package com.rocogz.syy.operation.dto.quotapply;

import lombok.Getter;
import lombok.Setter;

/**
 * 额度申请人信息Dto
 * @author zhangmin
 */
@Getter @Setter
public class QuotaLoginUserProfileDto extends QuoteAcctTypeDto {

    /**
     * 登录人名字
     */
    private String name;

    /**
     * 登录人手机号
     */
    private String mobile;


    // ========  以下是申请人的信息  ====


    /**
     * 发放主体的保险公司名称
     */
    private String insuranceCompanyName;

    /**
     * 发放主体类型：ROCO_ORG：保险公司，ENTERPRISE：合作企业，BUSINESS：平台商户，AGENT_COMPANY：代理公司，CAR_SALE_SERVICE：汽车4S店
     */
    private String issuingBodyType;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    private String issuingBodyName;

    /**
     * 登录人的实名认证状态
     */
    private String authStatus;

    /**
     * 申请人实名认证时：填写的员工号
     */
    private String empCode;

    /**
     * 申请人实名认证时：填写的部门名
     */
    private String deptName;

    /**
     * 发放主体是否是保险公司
     */
    public boolean isInsuranceCompany() {
        return "ROCO_ORG".equals(issuingBodyType);
    }
}
