package com.rocogz.syy.operation.entity.car.dealer;

import java.time.LocalDateTime;
import java.util.List;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 裂变种子entity
 * @date：2022/12/08
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("operate_fission_seed")
public class OperateFissionSeed extends IdEntity {

    private static final long serialVersionUID = 774747734702345644L;

    /**
    * 编号
    */
    private String code;
    
    /**
    * 姓名
    */
    @NotBlank(message = "姓名不能为空")
    private String name;
    
    /**
    * 手机号
    */
    @NotBlank(message = "手机号不能为空")
    private String mobile;
    
    /**
    * 性别（常量：MALE-男、FEMALE-女）
    */
    @NotBlank(message = "性别不能为空")
    private String gender;
    
    /**
    * 年龄
    */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer age;
    
    /**
    * 出生年
    */
    private String birthdayYear;
    
    /**
    * 出生月
    */
    private String birthdayMonth;
    
    /**
    * 出生日期
    */
    private String birthday;
    
    /**
    * 祖籍地省编码
    */
    private String homeTownProvinceCode;
    
    /**
    * 祖籍地省名称
    */
    private String homeTownProvinceName;
    
    /**
    * 祖籍地城市编码
    */
    private String homeTownCityCode;
    
    /**
    * 祖籍地城市名称
    */
    private String homeTownCityName;
    
    /**
    * 祖籍地区县编码
    */
    private String homeTownDistrictCode;
    
    /**
    * 祖籍地区县名称
    */
    private String homeTownDistrictName;
    
    /**
    * 安家地省编码
    */
    private String residenceProvinceCode;
    
    /**
    * 安家地省名称
    */
    private String residenceProvinceName;
    
    /**
    * 安家地城市编码
    */
    private String residenceCityCode;
    
    /**
    * 安家地城市名称
    */
    private String residenceCityName;
    
    /**
    * 安家地区县编码
    */
    private String residenceDistrictCode;
    
    /**
    * 安家地区县名称
    */
    private String residenceDistrictName;
    
    /**
    * 工作地省编码
    */
    private String workProvinceCode;
    
    /**
    * 工作地省名称
    */
    private String workProvinceName;
    
    /**
    * 工作地城市编码
    */
    private String workCityCode;
    
    /**
    * 工作地城市名称
    */
    private String workCityName;
    
    /**
    * 工作地区县编码
    */
    private String workDistrictCode;
    
    /**
    * 工作地区县名称
    */
    private String workDistrictName;
    
    /**
    * 所属4S店集团code
    */
    private String blocCode;
    
    /**
    * 所属4S店code
    */
    @NotBlank(message = "所属4S店不能为空")
    private String shopCode;
    
    /**
    * 工作岗位
    */
    @NotBlank(message = "工作岗位不能为空")
    private String job;
    
    /**
    * 在店工作年限
    */
    @NotBlank(message = "在店工作年限不能为空")
    private String serviceYear;
    
    /**
    * 负责业务情况
    */
    @NotBlank(message = "负责业务情况不能为空")
    private String responsibleBusiness;
    
    /**
    * 其他信息
    */
    private String extInfo;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;

    /**
     * 所属4S店集团名称
     */
    @TableField(exist = false)
    private String blocName;

    /**
     * 所属4S店集团简称
     */
    @TableField(exist = false)
    private String blocAbbreviationName;

    /**
     * 所属4S店业内名称
     */
    @TableField(exist = false)
    private String shopName;

    /**
     * 所属4S店营业执照名称
     */
    @TableField(exist = false)
    private String shopLicenseName;

    /**
     * 所属4S店标准规范名称
     */
    @TableField(exist = false)
    private String shopStandardName;

    /**
     * 登记人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

    /**
     * 种子履历列表
     */
    @TableField(exist = false)
    private List<OperateFissionSeedResume> resumes;
}