package com.rocogz.syy.operation.entity.inverst;

import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.InvestRateTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 调查问券选择题配置选项
 * </p>
 *
 * @author zhangmin
 * @since 2023-01-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OperateInverstQuestOption extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 问题编号
     *
     * @see OperateInverstConfigQuestion#questCode
     */
    private String questionCode;

    /**
     * 选择题的选项/标签Tag
     */
    private String opt;

    /**
     * 选项类型：正面标签/负面标签
     */
    private InvestRateTypeEnum type;

    /**
     * 选项索引号，用来展示选择题A，B，C等
     */
    private Integer seq;


}
