package com.rocogz.syy.operation.entity.quotapply;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 客户权益管理-> 额度申请包含的【团队/子发放主体】item
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter @Getter
@Accessors(chain = true)
public class OperateQuotaApplyItem extends IdEntity {

    /**
     * 申请单编码
     */
    private String applyCode;

    /**
     * 团队编号或 子发放主体编号
     */
    private String teamCode;

    /**
     * 团队/子发放主体 申请额度
     */
    private Integer teamQuota;


    /**
     * 团队/子发放主体简称
     */
    private transient String teamName;

}
