package com.rocogz.syy.operation.dto.car.dealer;

import com.rocogz.syy.operation.entity.car.dealer.OperateCarDealerContract;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 合同协议管理查询入参DTO
 * @Author 陈煜敏
 * @Date 2023/01/11 14:55
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
public class OperateCarDealerContractDto extends OperateCarDealerContract {

    /**
     * 协议状态
     */
    private String contractStatus;

    /**
     * 协议签订日期-开始
     */
    private String signDateStart;

    /**
     * 协议签订日期-结束
     */
    private String signDateEnd;

    /**
     * 创建时间-开始
     */
    private String createTimeStart;

    /**
     * 创建时间-结束
     */
    private String createTimeEnd;

    /**
     * 服务商权限
     */
    private List<String> agentPermissions;

    /**
     * 是否具备所有服务商权限
     */
    private Boolean isAllAgentPermissions;

    /**
     * 结算主体权限
     */
    private List<String> settleSubjectPermissions;

    /**
     * 是否具备所有结算主体权限
     */
    private Boolean isAllSettleSubjectPermissions;

    /**
     * 排序字段
     */
    private String sortBy;

    /**
     * 当前页码
     */
    Integer page;

    /**
     * 每页数量
     */
    Integer limit;

}
