package com.rocogz.syy.operation.entity.car.dealer;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.entity.attechment.OperateAttechment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.time.Period;
import java.util.List;

/**
 * <p>
 * 合同协议管理表
 * </p>
 * @author 陈煜敏
 * @Date 2023/01/11 14:55
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("operate_car_dealer_contract")
public class OperateCarDealerContract extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 协议编号
     */
    private String code;

    /**
     * 合同协议名称
     */
    private String name;

    /**
     * 服务商编号
     */
    private String agentCode;

    /**
     * 服务商简称
     */
    private String agentAbbreviation;

    /**
     * 结算主体编号
     */
    private String settleSubjectCode;

    /**
     * 结算主体简称
     */
    private String settleSubjectAbbreviation;

    /**
     * 甲方公司名称
     */
    private String partyCompanyA;

    /**
     * 乙方公司名称
     */
    private String partyCompanyB;

    /**
     * 协议签订日期
     */
    private LocalDate signDate;

    /**
     * 协议生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 协议失效日期
     */
    private LocalDate invalidDate;

    /**
     * 是否已上传协议扫描件
     */
    private String isUploadScan;

    /**
     * 备注
     */
    private String remark;

    /**
     * 归档状态
     * @see OperationConstant.OperateCarDealerContractArchiveStatus
     */
    private String archiveStatus;

    /**
     * 附件列表
     */
    @TableField(exist = false)
    private List<OperateAttechment> attechmentList;

    /**
     * 登记人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

    /**距协议到期天数*/
    public long getExpireDay(){
        //计算协议到期时间
        if(invalidDate != null){
            LocalDate today = LocalDate.now();
            long days = invalidDate.toEpochDay() - today.toEpochDay() + 1;
            if(days < 0){
                days = 0;
            }
            return days;
        }
        return 0;
    }

    /**协议状态*/
    public String getStatus(){
        if(effectiveDate != null && invalidDate != null){
            LocalDate today = LocalDate.now();
            //判断状态
            if(effectiveDate.isAfter(today)){//如果协议生效日期在今天以后，说明未生效
                return OperationConstant.OperateCarDealerContractStatus.NOT_ACTIVE;
            }else if(invalidDate.isBefore(today)){//协议失效日期在今天以前，说明已失效
                return OperationConstant.OperateCarDealerContractStatus.EXPIRED;
            }else{
                return OperationConstant.OperateCarDealerContractStatus.IN_ACTIVE;
            }
        }
        return null;
    }

}
