package com.rocogz.syy.operation.entity.car.dealer;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 4S店表相关日志表
 * </p>
 * @author 陈煜敏
 * @since 2022-12-06
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("operate_car_dealer_log")
public class OperateCarDealerLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 唯一识别码
     */
    private String identifyCode;

    /**
     * 变更信息
     */
    private String info;

    /**
     * 操作类型
     */
    private String operationType;

    /**
     * 操作人账户名
     */
    private String operationUsername;

    /**
     * 操作人姓名
     */
    private String operationUserNickname;

    /**
     * 操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime operationTime;

}
