package com.rocogz.syy.operation.entity.opinion;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.entity.attechment.OperateAttechment;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 意见反馈
 * </p>
 *
 * @author yinshihao
 * @since 2020-09-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class OperateOpinion extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 用户编号(填写该意见的用户编码)
     */
    private String userCode;

    /**
     * openid
     */
    private String openid;

    /**
     * 用户手机号
     */
    private String phone;

    /**
     * 来源(商户端,车主端等,字典值表示)
     */
    private String source;

    /**
     * 意见类型（目前有问题和建议两种类型,字典值表示）
     */
    private String opinionType;

    /**
     * 意见描述信息(限制字符在300个)
     */
    private String opinionDescribe;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 问题相关图片列表
     */
    @TableField(exist = false)
    private List<OperateAttechment> detailImages;

    /**
     * 用户今日提问次数
     */
    @TableField(exist = false)
    private String todayOpinionNum;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniName;
}
