package com.rocogz.syy.operation.enums;

import lombok.Getter;

/**
 * @author zhangmin
 * 调查问券评分类型， 正面/反面
 */
@Getter
public enum InvestRateTypeEnum {

    POSITIVE("正面评分"),  //例如 评分值>=8 算正面评分

    NEGATIVE("负面评分"); //例如 评分值< 8 算负面评分

    private String label;

    InvestRateTypeEnum(String label) {
        this.label = label;
    }


    /**
     * @param userSelectedRate 用户选择的评分
     * @param positiveMinRate  正面评分最新值
     * @return
     */
    public static InvestRateTypeEnum getRateType(int userSelectedRate, int positiveMinRate) {

        if (userSelectedRate >= positiveMinRate) {
            return POSITIVE;
        }
        return NEGATIVE;
    }
}
