package com.rocogz.syy.operation.dto.inverst;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 调查问券答题试券记录搜索参数
 * @author zhangmin
 */
@Setter @Getter
public class InverstPaperSearchParamDto {

    /**
     * 问券编号 【精确匹配】
     */
    private String inverstCode;

    /**
     * 答卷人会员编号 【精确匹配】
     */
    private String userCode;

    /**
     * 答题人手机号 【精确匹配】
     */
    private String userMobile;

    /**
     * 答题人openId 【精确匹配】
     */
    private String userOpenid;

    /**
     * 问券答题提交 开始时间
     */
    private LocalDateTime submitStartTime;

    /**
     * 问券答题提交 结束时间
     */
    private LocalDateTime submitEndTime;

    private Boolean export = Boolean.FALSE;
    private Integer page = 1;

    //如果是分页导出，不限制1次查询的数据条数，则limit =null
    private Integer limit = 10;

    /**
     * 查询 id < lePaperId 的数据
     */
    private Integer lePaperId;



}
