package com.rocogz.syy.operation.dto.quotapply;


import com.rocogz.syy.operation.entity.quotapply.OperateQuotaApply;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.text.Bidi;

/**
 * 审批/审核/划拨 详情页面
 *
 * @author zhangmin
 */
@Setter
@Getter
public class QuotaApplyApproveDetailVo extends OperateQuotaApply {

    // 主体额度账号 剩余额度信息

    /**
     * 可用额度，额度余额
     */
    private BigDecimal availableQuota;

    /**
     * 总额度
     */
    private BigDecimal totalQuota;

    /**
     * 已使用额度
     */
    private BigDecimal usedQuota;

    /**
     * 已冻结额度
     */
    private BigDecimal frozenQuota;


    //合作客户备付金电子账号信息如下：

    /**
     * 剩余金额
     */
    private BigDecimal availableCoverAmt;

    /**
     * 总金额
     */
    private BigDecimal totalCoverAmt;

    /**
     * 已使用金额/已使用额度
     */
    private BigDecimal usedCoverAmt;

    /**
     * 客户备付金电子账号
     */
    private String coverAcctCode;

    /**
     * 收款充值总金额
     */
    private BigDecimal totalDepositAmt;

    /**
     * 收款充值总笔数
     */
    private Integer totalDepositNum;

    /**
     * 是否有尚未归还的借款
     */
    private Boolean hasLoan;

    /**
     * 总借款金额
     */
    private BigDecimal totalLoanAmt;

    /**
     * 总已还款金额
     */
    private BigDecimal totalBackAmt;

    /**
     * 未还款金额
     */
    private BigDecimal totalUnbackAmt;



    // =====> 下面这些都是B端小程序 详情使用的字段

    //保险公司名称：取 发放主体对象上的 业内名称
    private String insuranceCompanyName;

    //发放主体类型
    private String issuingBodyType;

    /**
     * 登录人手机号
     */
    private String mobile;

    /*
    * 主体账号提交的申请，
    * 主体账号的 申请人实名认证时：填写的员工号
     */
    private String empCode;

    /**
     * 主体账号 申请人实名认证时：填写的部门名
     */
    private String deptName;


    /**
     * 是否是保险公司
     */
    public boolean isInsuranceCompany() {
        if(issuingBodyType == null) {
            return false;
        }
        return "ROCO_ORG".equals(issuingBodyType);
    }

}