package com.rocogz.syy.operation.entity.car.dealer;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 4S店集团表
 * </p>
 * @author 陈煜敏
 * @since 2022-12-06
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("operate_car_dealer_bloc")
public class OperateCarDealerBloc extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 集团编码
     */
    private String code;

    /**
     * 集团名称
     */
    private String name;

    /**
     * 集团简称
     */
    private String abbreviationName;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 集团经营年限
     */
    private String businessLife;

    /**
     * 集团经营性质
     */
    private String businessNature;

    /**
     * 集团规模分类
     */
    private String scaleClassify;

    /**
     * 集团4S店数量
     */
    private String shopNum;

    /**
     * 集团管理特征
     */
    private String manageCharacter;

    /**
     * 集团区域口碑
     */
    private String regionReputation;

    /**
     * 主要汽车品牌
     */
    private String carBrand;

    /**
     * 集团情况说明
     */
    private String remark;

    /**
     * 登记人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

}
