package com.rocogz.syy.operation.entity.filter;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 运营服务-筛选条件组信息表
 * </p>
 *
 * @author luoyc
 * @since 2021-01-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("operate_filter_group")
public class OperateFilterGroup extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 页面编号
     */
    private String filterPageCode;

    /**
     * 条件组名称
     */
    private String filterGroupName;

    /**
     * 排序号
     */
    private Integer sort;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;


}
