package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.QuotaApplyModeEnum;
import com.rocogz.syy.operation.enums.QuotaManageModeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 发放主体额度申请 申请人账号设置
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperateQuotaConfigAccount extends IdEntity {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * B端小程序 搜索 在填写的申请主体时 在此字段中搜索：【主体规范名称】【主体业内名称】
     */
    private String bodyNameKeyword;

    /**
     * 额度管理模式
     */
    private QuotaManageModeEnum quotaManageMode;

    /**
     * 申请模式
     */
    private QuotaApplyModeEnum applyMode;

    /**
     * 申请人列表
     */
    @TableField(exist = false)
    private List<OperateQuotaConfigApplier> applierList;

}
