package com.rocogz.syy.operation.dto.quotapply;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.*;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 小程序或管理端 搜索我的待办事项参数：包括 【待我审批/我已审批】，【待我审核/我已审核】,【待我划拨/我已划拨】页面
 *
 * @author zhangmin
 */
@Setter
@Getter
public class SearchQuotaApplyAffairParamDto {

    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;


    private int limit = 20;

    private int page = 1;

    /**
     * 待办/已办 事项类型
     */
    private QuotaApplyAffairTabEnum affairType;


    /**
     * 登录的用户Id，即办理事项的人id(查询待我划拨时按照用户id搜索）
     */
    private Integer loginUserId;

    /**
     * 登录的用户名，即办理事项的人
     */
    private String loginUserName;


    /**
     * 办理此事项处理结果：例如审核通过 或审批不通过 (B端查询参数)
     * @see OperationConstant.DictApproveResult#PASS
     */
    private String approveResult;


    //=========== 下面是Admin搜索使用的条件


    /**
     * 申请单号：【精确匹配】
     */
    private String applyCode;


    /**
     * 申请人名字:[模糊匹配]
     */
    private String applierName;

    /**
     * 申请人手机:[交互模糊匹配]
     */
    private String applierMobile;

    /**
     * 查询的发放主体账号列表
     */
    private List<String> issuingBodyCodeList;

    /**
     * 服务商编号列表
     */
    private List<String> agentCodeList;

    /**
     * 申请模式
     */
    private QuotaApplyModeEnum applyMode;

    /**
     * 额度管理模式
     */
    private QuotaManageModeEnum quotaManageMode;

    /**
     * 备付金模式下：充值类型
     */
    private CoverDepositTypeEnum depositType;

    /***
     * 申请端入口
     * @see OperationConstant.DictQuotaApplyPortal#B_WEAPP
     */
    private String portal;


    /**
     * 申请开始日期
     */
    private String startDate;

    /**
     * 申请结束日期
     */
    private String endDate;

    /**
     * 划拨开始日期
     */
    private String allocateStartDate;

    /**
     * 划拨结束日期
     */
    private String allocateEndDate;




    @JsonIgnore
    public String getLikeApplierName() {
        if (StringUtils.isBlank(applierName)) {
            return null;
        }
        return "%" + applierName + "%";
    }


    @JsonIgnore
    public String getLikeApplierMobile() {
        if (StringUtils.isBlank(applierMobile)) {
            return null;
        }
        return "%" + applierMobile + "%";
    }




    public String getStartDate() {
        if (StringUtils.isBlank(startDate)) {
            return null;
        }

        return startDate + OperationConstant.MIN_TIME_SUFFIX;
    }


    public String getEndDate() {
        if (StringUtils.isBlank(endDate)) {
            return null;
        }

        return endDate + OperationConstant.MAX_TIME_SUFFIX;
    }

    public String getAllocateStartDate() {
        if (StringUtils.isBlank(allocateStartDate)) {
            return null;
        }

        return allocateStartDate + OperationConstant.MIN_TIME_SUFFIX;
    }


    public String getAllocateEndDate() {
        if (StringUtils.isBlank(allocateEndDate)) {
            return null;
        }

        return allocateEndDate + OperationConstant.MAX_TIME_SUFFIX;
    }




}
