package com.rocogz.syy.operation.entity.inverst;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.dto.inverst.OperateExamPaperDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 调查问券用户答题试券记录
 * </p>
 *
 * @author zhangmin
 * @since 2023-01-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OperateInverstPaper extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 答题券编号，就是考试券编号
     */
    private String paperCode;

    /**
     * 问券编号
     *
     * @see OperateInverstConfig#inverstCode
     */
    private String inverstCode;

    /**
     * 问券主题
     */
    private String topic;

    /**
     * 问卷说明
     */
    private String instruction;

    /**
     * 问卷头部banner图
     */
    private String bannerUrl;

    /**
     * 答题人会员编号
     */
    private String userCode;

    /**
     * 答题人手机号
     */
    private String userMobile;

    /**
     * 答题人openId
     */
    private String userOpenid;

    /**
     * 问券答题提交试券时间
     */
    private LocalDateTime submitTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 问券答题详情json
     */
    private String paperDetail;

    /**
     * 问券答题详情 答题记录
     */
    @TableField(exist = false)
    private OperateExamPaperDto examPaper;


}
