package com.rocogz.syy.operation.dto.inverst;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 提现问券：搜索参数
 * @author zhangmin
 */
@Setter @Getter
public class WithdrawPaperSearchParamDto {

    /**
     * 发放主体编号
     */
    private List<String> issuingBodyCodeList;

    /**
     * 小程序Id
     */
    private List<String> miniAppIdList;

    /**
     *问卷编号【精确匹配】
     */
    private String paperCode;

    /**
     * 答卷人会员编号 【精确匹配】
     */
    private String userCode;

    /**
     * 答题人手机号 【模糊匹配】
     */
    private String userMobile;

    /**
     * 答题人姓名 【模糊匹配】
     */
    private String userFullName;

    /**
     * 车牌号 【模糊匹配】
     */
    private String carLicence;

    /**
     * 车架号 【模糊匹配】
     */
    private String vinNo;


    //如果是true, 则表示导出
    private Boolean export = Boolean.FALSE;

    //是否是导出 考试券详情
    private Boolean exportPaperDetail = Boolean.FALSE;


    private Integer page = 1;

    //如果是分页导出，不限制1次查询的数据条数，则limit =null
    private Integer limit = 10;

    /**
     * 查询 id < lePaperId 的数据
     */
    private Integer lePaperId;

}
