package com.rocogz.syy.operation.dto.quotapply;

import com.rocogz.syy.operation.enums.QuotaApplyModeEnum;
import com.rocogz.syy.operation.enums.QuotaApplyNodeApproverTypeEnum;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 额度申请 审批进度 返回的dto,用来发送微信公众号进度 推送消息
 *
 * @author zhangmin
 */
@Setter
@Getter
public class QuotaApplyCurProcessDto {

    /***
     * 申请端入口
     * @see OperationConstant.DictQuotaApplyPortal#B_WEAPP
     */
    private String portal;


    //本次审批/审核 是否通过
    private Boolean approvePass;

    /**
     * 申请单号
     */
    private String applyCode;

    /**
     * 申请人用户名
     */
    private String applierUser;

    /**
     * 审批人名字
     */
    private String applierName;

    /**
     * 额度申请时间
     */
    private LocalDateTime createTime;

    /**
     * 申请的额度金额
     */
    private String quota;

    /**
     * 审批进度：当前待审批人用户名,如果没有设置审批结点，则没有审批人，因为创建的申请单可以不设置成不需要审批
     */
    private List<String> curApproverUserList;

    /**
     * 审批进度：当前审批节点类型,即审批业务类型
     *
     * @see QuotaApproveNodeTypeEnum#AUDIT
     */
    private String curNodeType;

    private String curNodeName;

    /**
     * 申请模式
     */
    private QuotaApplyModeEnum applyMode;

    /**
     * 当前节点 审批人账号类型
     */
    private QuotaApplyNodeApproverTypeEnum approverType;

    /**
     * 额度申请单：当前状态
     */
    private String applyStatus;


    //审批时间
    private LocalDateTime approvedTime;


    //审批人名字
    private String approvedName;


    /**
     * 划拨操作 用户Id
     */
    private List<Integer> transferUserIdList;

}
