package com.rocogz.syy.operation.dto.quotapply;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.syy.operation.enums.QuotaApplyAffairTabEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * PC管理端 搜索 当前登录人  能审批的主体
 *
 * @author zhangmin
 */
@Setter
@Getter
public class SearchCanApproveIssueBodyParamDto {

    /**
     * 待办/已办 事项类型
     */
    private QuotaApplyAffairTabEnum affairType;

    /**
     * 搜索字段：主体业内名字，主体规范名称
     */
    private String keyword;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;


    /**
     * 审批人用户名，登录的用户名
     */
    private String approverUser;


    private Integer limit = 20;

    private Integer page = 1;

    public String getKeywordLike() {
        return StringUtils.isBlank(keyword) ? null : "%" + keyword + "%";
    }

}
