package com.rocogz.syy.operation.dto.quotapply;

import com.rocogz.syy.operation.enums.ApproveQueryTypeTabEnum;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Getter;
import lombok.Setter;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 小程序端搜索 与我相关的审批
 * @author zhangmin
 */
@Setter @Getter
public class WapSearchQuotaApprovalParamDto extends BaseSearchQuotaApplyDto {

    /**
     * 审批人用户名
     */
    private String approverUser;

    /**
     * 审批业务类型
     */
    private QuotaApproveNodeTypeEnum approveType = QuotaApproveNodeTypeEnum.AUDIT;

    /**
     * 统计Tab类型
     */
    private ApproveQueryTypeTabEnum statisType = ApproveQueryTypeTabEnum.ALL;


    /**
     * 需要置顶的申请单状态
     */
    private String topStatus;


    public WapSearchQuotaApprovalParamDto() {
        this.setLimit(10);
    }


}
