package com.rocogz.syy.operation.entity.car.dealer;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 交互动作记录附加信息entity
 * @date：2022/12/08
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("operate_interactive_record_ext")
public class OperateInteractiveRecordExt extends IdEntity {

    private static final long serialVersionUID = -43563411130132488L;

    /**
    * 交互动作记录code
    */
    private String interactiveRecordCode;
    
    /**
    * 交互简要说明
    */
    private String interactiveDescription;
    
    /**
    * O2O功能（常量：DESPERATE-非常需要、NEED-需要、UNNEED-不需要）
    */
    private String needO2oFeature;
    
    /**
    * 使用我方O2O功能的意愿（DESPERATE-非常愿意并期待、TRY-愿意试试、CONDITION_TRY-愿意试试但需要批准、UNWILING-不愿意）
    */
    private String useO2oFeatureDesire;
    
    /**
    * 营销活动工具（常量：DESPERATE-非常需要、NEED-需要、UNNEED-不需要）
    */
    private String needActivityFeature;
    
    /**
    * 使用我方定制工具的意愿（DESPERATE-非常愿意并期待、TRY-愿意试试、CONDITION_TRY-愿意试试但需要批准、UNWILING-不愿意）
    */
    private String useCustomFeatureDesire;
    
    /**
    * 对方对财税敏感度（常量：VERY_SENSITIVE-非常敏感、SENSITIVE-敏感、NOT_SENSITIVE-有意识但不敏感、FULL_NOT_SENSITIVE-完全不敏感）
    */
    private String financeSensitivity;
    
    /**
    * 是否认可我们的处理方式（常量：APPROVAL-认可、INDIFFERENT-无所谓、NOT_APPROVAL-不认可）
    */
    private String handleWayOpinion;
    
    /**
    * 对方财税观点
    */
    private String financeOpinion;
    
    /**
    * 对方对税筹敏感度（常量：VERY_SENSITIVE-非常敏感、SENSITIVE-敏感、NOT_SENSITIVE-有意识但不敏感、FULL_NOT_SENSITIVE-完全不敏感）
    */
    private String taxSensitivity;
    
    /**
    * 是否有合作可能性（常量：Y-有、N-没有）
    */
    private String cooperationPossibility;
    
    /**
    * 合作意向程度（常量：INSTANTLY-马上、INTERESTED-有意向、VAGUE-不明确、NO_HURRY-不着急、NO_COOPERATION-不合作）
    */
    private String cooperationIntention;
    
    /**
    * 对方税筹观点
    */
    private String taxOpinion;
    
    /**
    * 现状情况
    */
    private String reality;
    
    /**
    * 对方认可我们的地方
    */
    private String approval;
    
    /**
    * 双方达成一致的观点
    */
    private String agreeOn;
    
    /**
    * 对方关注的业务场景需求
    */
    private String focusBusinessRequirement;
    
    /**
    * 对方关注的系统功能
    */
    private String focusSystemFeature;
    
    /**
    * 下一步动作计划
    */
    private String nextPlan;
    
    /**
    * 有哪些困难
    */
    private String difficulty;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;
}