package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 修复额度申请历史数据的中间表
 * </p>
 *
 * @author zhangmin
 * @since 2023-02-18
 */
@Data
@Accessors(chain = true)
public class OperateQuotaApplyRepairData extends IdEntity {

    /**
     * 迁移 修复，历史配置的主体节点上的审批人信息
     */
    public static final String  REPAIR_NODE_APPROVER = "NODE_APPROVER";

    /**
     * 修复历史数据上的时间线数据
     */
    public static final String  REPAIR_TIME_LINE = "TIME_LINE";


    private String applyCode;

    private String issuingBodyCode;

    private Integer maxVersion;

    /**
     * 是否已经成功了：1 表示处理了
     */
    private Boolean handled;

    /**
     * 修复数据类型：NODE_APPROVER, TIME_LINE
     */
    private String repairType;


}
