/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.operation.dto.inverst;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.operation.dto.inverst.OperateExamQuestOptionDto;
import com.rocogz.syy.operation.enums.InverstQuestTypeEnum;
import com.rocogz.syy.operation.enums.InvestRateTypeEnum;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OperateExamQuestDto {
    private String questCode;
    private InverstQuestTypeEnum questType;
    private String questTitle;
    private Integer questSeq;
    private Boolean mustAnswer;
    private Integer rateMin;
    private Integer rateMax;
    private Integer selectedRate;
    private InvestRateTypeEnum rateResultType;
    private String answer;
    private List<OperateExamQuestOptionDto> optionList;

    public String getRenderAnswer() {
        String empty = "";
        if (this.questType == null) {
            return empty;
        }
        switch (this.questType) {
            case RATE: {
                return this.selectedRate == null ? empty : String.valueOf(this.selectedRate);
            }
            case ASK_ANSWER: {
                return this.answer == null ? empty : this.answer;
            }
            case TAG: {
                return StringUtils.collectionToCommaDelimitedString(this.getCheckedOptions());
            }
        }
        return empty;
    }

    public List<String> getCheckedOptions() {
        if (CollectionUtils.isEmpty(this.optionList)) {
            return Collections.emptyList();
        }
        return this.optionList.stream().filter(option -> Boolean.TRUE.equals(option.getChecked())).map(OperateExamQuestOptionDto::getOpt).collect(Collectors.toList());
    }

    public OperateExamQuestDto setQuestCode(String questCode) {
        this.questCode = questCode;
        return this;
    }

    public OperateExamQuestDto setQuestType(InverstQuestTypeEnum questType) {
        this.questType = questType;
        return this;
    }

    public OperateExamQuestDto setQuestTitle(String questTitle) {
        this.questTitle = questTitle;
        return this;
    }

    public OperateExamQuestDto setQuestSeq(Integer questSeq) {
        this.questSeq = questSeq;
        return this;
    }

    public OperateExamQuestDto setMustAnswer(Boolean mustAnswer) {
        this.mustAnswer = mustAnswer;
        return this;
    }

    public OperateExamQuestDto setRateMin(Integer rateMin) {
        this.rateMin = rateMin;
        return this;
    }

    public OperateExamQuestDto setRateMax(Integer rateMax) {
        this.rateMax = rateMax;
        return this;
    }

    public OperateExamQuestDto setSelectedRate(Integer selectedRate) {
        this.selectedRate = selectedRate;
        return this;
    }

    public OperateExamQuestDto setRateResultType(InvestRateTypeEnum rateResultType) {
        this.rateResultType = rateResultType;
        return this;
    }

    public OperateExamQuestDto setAnswer(String answer) {
        this.answer = answer;
        return this;
    }

    public OperateExamQuestDto setOptionList(List<OperateExamQuestOptionDto> optionList) {
        this.optionList = optionList;
        return this;
    }

    public String getQuestCode() {
        return this.questCode;
    }

    public InverstQuestTypeEnum getQuestType() {
        return this.questType;
    }

    public String getQuestTitle() {
        return this.questTitle;
    }

    public Integer getQuestSeq() {
        return this.questSeq;
    }

    public Boolean getMustAnswer() {
        return this.mustAnswer;
    }

    public Integer getRateMin() {
        return this.rateMin;
    }

    public Integer getRateMax() {
        return this.rateMax;
    }

    public Integer getSelectedRate() {
        return this.selectedRate;
    }

    public InvestRateTypeEnum getRateResultType() {
        return this.rateResultType;
    }

    public String getAnswer() {
        return this.answer;
    }

    public List<OperateExamQuestOptionDto> getOptionList() {
        return this.optionList;
    }
}

