package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.QuotaApplyNodeApproverTypeEnum;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 额度申请 审批流节点配置的审批人信息
 * </p>
 *
 * @author zhangmin
 * @since 2023-02-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OperateQuotaConfigNodeApprover extends IdEntity {

    /**
     * 审批节点编号
     */
    private String nodeCode;

    /**
     * 审批人用户名
     */
    private String approverUser;

    /**
     * 审批人名字
     */
    private String approverName;

    /**
     * 审批人手机号
     */
    private String approverMobile;

    /**
     * 节点业务类型：审核或审批
     */
    private QuotaApproveNodeTypeEnum nodeType;

    /**
     * 审批人账号类型
     */
    private QuotaApplyNodeApproverTypeEnum approverType;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 如果审批人账号类型是AGENT,并且issuingBodyCode=null, 服务商基础节点配置的审批人所属服务商编号
     */
    private String agentCode;


}
