package com.rocogz.syy.operation.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.client.iiuv.IiuvReqParam;
import com.rocogz.syy.operation.client.qr.QrReqParam;
import com.rocogz.syy.operation.dto.*;
import com.rocogz.syy.operation.dto.car.dealer.*;
import com.rocogz.syy.operation.dto.filter.OperateFilterGroupDto;
import com.rocogz.syy.operation.dto.inverst.*;
import com.rocogz.syy.operation.dto.label.OperateLabelDto;
import com.rocogz.syy.operation.dto.label.OperateSaveLabelDto;
import com.rocogz.syy.operation.dto.qr.CreateIiuvDTO;
import com.rocogz.syy.operation.dto.qr.OperateQrScanHistoryDTO;
import com.rocogz.syy.operation.dto.quotapply.*;
import com.rocogz.syy.operation.dto.settle.SettleDistributionDto;
import com.rocogz.syy.operation.dto.settle.SettleDistributionLogDto;
import com.rocogz.syy.operation.dto.settle.SettleDistributionReq;
import com.rocogz.syy.operation.entity.*;
import com.rocogz.syy.operation.entity.car.dealer.*;
import com.rocogz.syy.operation.entity.filter.OperateFilterGroup;
import com.rocogz.syy.operation.entity.filter.OperateFilterLabel;
import com.rocogz.syy.operation.entity.filter.OperateFilterLog;
import com.rocogz.syy.operation.entity.filter.OperateFilterPage;
import com.rocogz.syy.operation.entity.inverst.OperateInverstConfig;
import com.rocogz.syy.operation.entity.inverst.OperateInverstPaper;
import com.rocogz.syy.operation.entity.inverst.OperateInverstWithdrawPaper;
import com.rocogz.syy.operation.entity.label.OperateLabel;
import com.rocogz.syy.operation.entity.message.OperateIssuingBodyMessage;
import com.rocogz.syy.operation.entity.opinion.OperateOpinion;
import com.rocogz.syy.operation.entity.qr.*;
import com.rocogz.syy.operation.entity.quotapply.*;
import com.rocogz.syy.operation.entity.settle.SettleDistribution;
import com.rocogz.syy.operation.entity.settle.SettleDistributionDetail;
import com.rocogz.syy.operation.entity.settle.SettleDistributionLog;
import com.rocogz.syy.operation.entity.settle.SettleDistributionReturnDetail;
import com.rocogz.syy.operation.enums.ApproveQueryTypeTabEnum;
import com.rocogz.syy.operation.enums.QuotaApplyNodeApproverTypeEnum;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author zhangmin
 * @date 2020/4/3
 */
public interface IOperationClientService {

    // =====  start 审核管理->审核申请   ========

    /**
     * 后台列表查询
     *
     * @param approveCode   审批单号
     * @param bussinessCode 业务对象编号
     * @param bussinessName 业务对象名称
     * @param bussinessType 业务类型编号
     * @param bussinessItem 业务项目
     * @param approved      是否已审核,默认未审核
     */
    @GetMapping("/api/operation/approvement")
    PageTable<Approvement> searchApproment(@RequestParam(name = "approveCode", required = false) String approveCode,
                                           @RequestParam(name = "bussinessCode", required = false) String bussinessCode,
                                           @RequestParam(name = "bussinessName", required = false) String bussinessName,
                                           @RequestParam(name = "bussinessType", required = false) String bussinessType,
                                           @RequestParam(name = "bussinessItem", required = false) String bussinessItem,
                                           @RequestParam(name = "approved", defaultValue = "false") Boolean approved,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 判断申请是否重复
     *
     * @param bussinessCode
     * @return
     */
    @GetMapping("/api/operation/approvement/findApprovement")
    Response<Approvement> findApprovement(@RequestParam(name = "bussinessCode", required = false) String bussinessCode);

    /**
     * 创建审批申请
     */
    @PostMapping("/api/operation/approvement/create")
    Response<String> createApprovement(@RequestBody Approvement approve);

    /**
     * 更新审批信息
     */
    @PostMapping("/api/operation/approvement/update")
    Response<String> updateApprovement(@RequestBody Approvement approve);

    /**
     * 审批操作
     */
    @PostMapping("/api/operation/approvement/approve")
    Response<String> approveApprovement(@RequestBody Approvement approve);

    @GetMapping("/api/operation/approvement/getBatchApprove")
    PageTable<Approvement> getBatchApprove(@RequestParam(name = "approveCodes", required = false) String[] approveCodes,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    //  =========  end of  审核管理->审核申请   ===========

    //  =========  start of  banner 模块   ===========

    /**
     * banner列表
     *
     * @param prefecturekeyword 分区搜索
     * @param status            状态
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/banner")
    PageTable<OperateBanner> findOperateBanner(
            @RequestParam(name = "prefecturekeyword", required = false) String[] prefecturekeyword,
            @RequestParam(name = "status", required = false) String status,
            @RequestParam(name = "showLocation", required = false) String showLocation,
            @RequestParam(name = "linkType", required = false) String linkType,
            @RequestParam(name = "systemEnd", required = false) String systemEnd,
            @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
            @RequestParam(name = "miniAppid", required = false) String miniAppid,
            @RequestParam(name = "limit", defaultValue = "20") int limit,
            @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 新增和更新
     *
     * @param operateBanner
     * @return
     */
    @PostMapping("/api/operation/banner/createOrUpdateBanner")
    Response createOrUpdateBanner(@RequestBody OperateBanner operateBanner);

    /**
     * 根据code删除banner
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/banner/deleteBanner")
    Response deleteBanner(@RequestParam(name = "code") String code);

    /**
     * banner状态改变
     *
     * @param operateBanner banner
     * @return
     */
    @PostMapping("/api/operation/banner/status")
    Response switchBannerStatus(@RequestBody OperateBanner operateBanner);

    /**
     * 根据id查询banner信息
     *
     * @param id bannerid
     * @return
     */
    @GetMapping("/api/operation/banner/{id}")
    Response<OperateBanner> getOperateBannerById(@PathVariable("id") Integer id);

    /**
     * banner专区
     *
     * @param code bannerCode
     * @return
     */
    @PostMapping("/api/operation/banner/findPrefectureByCode")
    Response<List<OperateBannerPrefecture>> findPrefectureListByCode(@RequestParam(name = "code") String code);

    /**
     * banner管理-检测title是否重复
     *
     * @param code
     * @param title
     * @return
     */
    @PostMapping("/api/operation/banner/checkTitle")
    Response<List<OperateBanner>> checkTitle(@RequestParam(name = "code", required = false) String code, @RequestParam(name = "title") String title);

    /**
     * 车主端-首页banner信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/banner/findIndexBanner")
    Response<List<OperateBanner>> findIndexBanner(@RequestParam(name = "code") String code, @RequestParam(name = "systemEnd") String systemEnd);

    /**
     * 车主端-去加油banner信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/banner/findOilingBanner")
    Response<List<OperateBanner>> findOilingBanner(@RequestParam(name = "code") String code, @RequestParam(name = "showLocation") String showLocation, @RequestParam(name = "systemEnd") String systemEnd);


    /**
     * 检测专区加名称唯一
     *
     * @param id
     * @param pcodeList
     * @param name
     * @return
     */
    @GetMapping("/api/operation/banner/checkBannerUnique")
    Response<List<OperateBannerPrefecture>> checkBannerUnique(@RequestParam(name = "code", required = false) String code, @RequestParam(name = "pcodeList") List<String> pcodeList, @RequestParam(name = "name") String name);

    // =========  end of  banner 模块   ===========

    //  =========  start of  block 模块   ===========

    /**
     * 车主端-根据专区code查询版块
     *
     * @param prefectureCode
     * @return
     */
    @GetMapping("/api/operation/block/findIndexOperateBlock")
    Response<List<OperateBlock>> findIndexOperateBlock(@RequestParam(name = "prefectureCode") String prefectureCode,
                                                       @RequestParam(name = "systemEnd") String systemEnd,
                                                       @RequestParam(name = "recommendType") String recommendType);

    /**
     * 版块管理-查询列表
     *
     * @param blockName
     * @param prefectureCode
     * @param status
     * @param areaCodes
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/block")
    PageTable<OperateBlock> searchBlock(@RequestParam(name = "blockName", required = false) String blockName,
                                        @RequestParam(name = "prefectureCode", required = false) String prefectureCode,
                                        @RequestParam(name = "status", required = false) String status,
                                        @RequestParam(name = "recommendType", required = false) String recommendType,
                                        @RequestParam(name = "systemEnd", required = false) String systemEnd,
                                        @RequestParam(name = "areaCodes", required = false) String[] areaCodes,
                                        @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
                                        @RequestParam(name = "miniAppid", required = false) String miniAppid,
                                        @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                        @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 版块管理-更新版块的状态和排序
     *
     * @param operateBlock
     * @return
     */
    @PostMapping("/api/operation/block/statusOrSort")
    Response switchBlockStatusOrSort(@RequestBody OperateBlock operateBlock);

    /**
     * 版块管理-根据code删除版块
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/block/deleteBlock")
    Response deleteBlock(@RequestParam(name = "code") String code);

    /**
     * 新增和更新operateBlock
     *
     * @param operateBlock
     * @return
     */
    @PostMapping("/api/operation/block/createOrUpdateBlock")
    Response createOrUpdateBlock(@RequestBody OperateBlock operateBlock);

    /**
     * 版块管理-根据id查询版块
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/block/{id}")
    Response<OperateBlock> getOperateBlockById(@PathVariable("id") Integer id);

    /**
     * 根据code查询版块信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/block/getOperateBannerByCode")
    Response<OperateBlock> getOperateBannerByCode(@RequestParam(name = "code") String code);

    /**
     * 版块管理/车主端-根据版块code查询下面的商户
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/block/blockMerchantList")
    Response<List<OperateBlockMerchant>> blockMerchantList(@RequestParam(name = "code") String code);

    /**
     * 版块管理-根据版块code新增更新下面的商户
     *
     * @param code
     * @param merchenctCode
     * @return
     */
    @GetMapping("/api/operation/block/updateBlockMerchenct")
    Response updateBlockMerchenct(@RequestParam(name = "code", required = false) String code,
                                  @RequestParam(name = "merchenctCode", required = false) String[] merchenctCode);

    /**
     * 版块管理-根据版块code和商户code删除版块下的商户
     *
     * @param blockCode
     * @param merchantCode
     * @return
     */
    @PostMapping("/api/operation/block/removeMerchenct")
    Response removeMerchenct(@RequestParam(name = "blockCode") String blockCode, @RequestParam(name = "merchantCode") String merchantCode);

    /**
     * 版块管理-商户code更新位置值
     *
     * @param OperateBlockMerchant
     * @return
     */
    @PostMapping("/api/operation/block/merchenctSort")
    Response merchenctSort(@RequestBody OperateBlockMerchant OperateBlockMerchant);

    /**
     * 检测专区加名称唯一
     *
     * @param id
     * @param pcodeList
     * @param name
     * @return
     */
    @GetMapping("/api/operation/block/checkBlockUnique")
    Response<List<OperateBlock>> checkBlockUnique(@RequestParam(name = "id", required = false) Integer id, @RequestParam(name = "pcodeList") List<String> pcodeList, @RequestParam(name = "name") String name);


    // =========  end of  block 模块   ===========

    //  =========  start of  栏目 模块   ===========

    @GetMapping("/api/operation/column")
    PageTable<OperateColumn> searchColumn(@RequestParam(name = "areaCodes", required = false) String[] areaCodes,
                                          @RequestParam(name = "name", required = false) String name,
                                          @RequestParam(name = "columnType", required = false) String columnType,
                                          @RequestParam(name = "status", required = false) String status,
                                          @RequestParam(name = "systemEnd", required = false) String systemEnd,
                                          @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
                                          @RequestParam(name = "miniAppid", required = false) String miniAppid,
                                          @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page", defaultValue = "1") Integer page);

    @GetMapping("/api/operation/column/searchPointsColumn")
    PageTable<OperateColumn> searchPointsColumn(
            @RequestParam(name = "name", required = false) String name,
            @RequestParam(name = "columnType", required = false) String columnType,
            @RequestParam(name = "status", required = false) String status,
            @RequestParam(name = "systemEnd", required = false) String systemEnd,
            @RequestParam(name = "miniAppid", required = false) String miniAppid,
            @RequestParam(value = "miniAppidList", required = false) List<String> miniAppidList,
            @RequestParam(name = "limit", defaultValue = "20") Integer limit,
            @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 栏目管理-更新栏目的状态和排序
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/statusOrSort")
    Response switchColumnStatusOrSort(@RequestBody OperateColumn operateColumn);

    /**
     * 栏目管理-根据code删除栏目
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/column/deleteColumn")
    Response deleteColumn(@RequestParam(name = "code") String code);

    /**
     * 新增和更新operateBlock
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/createOrUpdateColumn")
    Response createOrUpdateColumn(@RequestBody OperateColumn operateColumn);

    /**
     * 版块管理-根据id查询栏目
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/column/{id}")
    Response<OperateColumn> getOperateColumnById(@PathVariable("id") Integer id);

    /**
     * 车主端-根据专区code查询栏目
     *
     * @param prefectureCode
     * @return
     */
    @GetMapping("/api/operation/column/findIndexOperateColumn")
    Response<List<OperateColumn>> findIndexOperateColumn(@RequestParam(name = "prefectureCode") String prefectureCode, @RequestParam(name = "systemEnd") String systemEnd);

    @GetMapping("/api/operation/column/findIndexPointsOperateColumn")
    Response<List<OperateColumn>> findIndexPointsOperateColumn(@RequestParam(name = "miniAppid") String miniAppid);

    /**
     * 检测专区加名称唯一
     *
     * @param id
     * @param prefectureCode
     * @param cloumnName
     * @return
     */
    @GetMapping("/api/operation/column/checkUnique")
    Response<List<OperateColumn>> checkUnique(@RequestParam(name = "id", required = false) Integer id, @RequestParam(name = "pcodeList") List<String> pcodeList, @RequestParam(name = "cloumnName") String cloumnName);


    /**
     * 检测平台+名称唯一
     *
     * @param id
     * @param miniAppid
     * @param cloumnName
     * @return
     */
    @GetMapping("/api/operation/column/checkPointsUnique")
    Response<List<OperateColumn>> checkPointsUnique(@RequestParam(name = "id", required = false) Integer id, @RequestParam(name = "miniAppid") String miniAppid, @RequestParam(name = "cloumnName") String cloumnName);

    // =========  end of  栏目 模块   ===========

    //  =========  start of  systemMessage 模块   ===========

    /**
     * 系统信息列表
     *
     * @param title      信息标题(模糊匹配)
     * @param sendStatus 发布状态
     * @param showPlace  展示位置
     * @param page       页码
     * @param limit      每页条数
     * @return
     */
    @GetMapping("/api/operation/systemMessage")
    PageTable<SystemMessage> findSystemMessageList(@RequestParam(value = "title", required = false) String title,
                                                   @RequestParam(value = "sendStatus", required = false) String sendStatus,
                                                   @RequestParam(value = "showPlace", required = false) String showPlace,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 创建或更新系统信息
     *
     * @param systemMessage
     * @return
     */
    @PostMapping("/api/operation/systemMessage/saveOrUpdateSystemMessage")
    Response saveOrUpdateSystemMessage(@RequestBody SystemMessage systemMessage);

    /**
     * 修改发布状态
     *
     * @param systemMessage
     * @return
     */
    @PostMapping("/api/operation/systemMessage/changeSystemMessageSendStatus")
    Response changeSystemMessageSendStatus(@RequestBody SystemMessage systemMessage);

    /**
     * 复制系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/copySystemMessage/{id}")
    Response copySystemMessage(@PathVariable("id") Integer id);

    /**
     * 删除系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/deleteSystemMessageById/{id}")
    Response deleteSystemMessageById(@PathVariable("id") Integer id);

    /**
     * 根据id获取系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/getSystemMessageById/{id}")
    Response<SystemMessage> getSystemMessageById(@PathVariable("id") Integer id);

    /**
     * 根据code获取系统信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/systemMessage/getSystemMessageByCode/{code}")
    Response<SystemMessage> getSystemMessageByCode(@PathVariable("code") String code);

    /**
     * 消息列表页根据专区编码获取系统信息列表(分页)
     *
     * @param prefectureCode 专区编码
     * @param showPlace      展示位置
     * @param limit          每页数量
     * @param page           页码
     * @return
     */
    @GetMapping("/api/operation/systemMessage/pageSystemMessageListByPrefectureCode")
    PageTable<SystemMessage> pageSystemMessageListByPrefectureCode(@RequestParam("prefectureCode") String prefectureCode,
                                                                   @RequestParam("showPlace") String showPlace,
                                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 首页根据专区编码获取系统信息列表(不分页)
     *
     * @param prefectureCode 专区编码
     * @param showPlace      展示位置
     * @return
     */
    @GetMapping("/api/operation/systemMessage/findSystemMessageListByPrefectureCode")
    Response<List<SystemMessage>> findSystemMessageListByPrefectureCode(@RequestParam("prefectureCode") String prefectureCode, @RequestParam("showPlace") String showPlace);
    // =========  end of  systemMessage 模块   ===========

    //  =========  start of message 模块   ===========

    /**
     * 根据参数查找消息模板列表
     *
     * @return
     */
    @GetMapping("/api/operation/msg/template/findMsgTemplateList")
    PageTable<OperateMsgTemplate> findMsgTemplateList(@RequestParam(value = "templateCode", required = false) String templateCode,
                                                      @RequestParam(value = "templateTitle", required = false) String templateTitle,
                                                      @RequestParam(value = "smsCode", required = false) String smsCode,
                                                      @RequestParam(value = "signName", required = false) String signName,
                                                      @RequestParam(value = "excludeTemplateCodes", required = false) List<String> excludeTemplateCodes,
                                                      @RequestParam(value = "platformCodeList", required = false) List<String> platformCodeList,
                                                      @RequestParam(value = "templateProperties", required = false) String templateProperties,
                                                      @RequestParam(value = "status", required = false) String status,
                                                      @RequestParam(value = "isIssuingBodySelect", required = false) boolean isIssuingBodySelect,
                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 保存或更新消息模板
     *
     * @return
     */
    @PostMapping("/api/operation/msg/template/saveOrUpdateMsgTemplate")
    Response saveOrUpdateMsgTemplate(@RequestBody OperateMsgTemplate operateMsgTemplate);

    /**
     * 根据templateCode 删除消息模板
     *
     * @param templateCode
     * @return
     */
    @GetMapping("/api/operation/msg/template/deleteMsgTemplateByTemplateCode/{templateCode}")
    Response deleteMsgTemplateByTemplateCode(@PathVariable("templateCode") String templateCode);

    /**
     * 根据templateCode 获取消息模板
     *
     * @param templateCode
     * @return
     */
    @GetMapping("/api/operation/msg/template/findMsgTemplateByTemplateCode/{templateCode}")
    Response<OperateMsgTemplate> findMsgTemplateByTemplateCode(@PathVariable("templateCode") String templateCode);

    /**
     * 根据templateCodes 获取消息模板
     *
     * @param templateCodes
     * @return
     */
    @GetMapping("/api/operation/msg/template/findMsgTemplateByTemplateCodes")
    Response<List<OperateMsgTemplate>> findMsgTemplateByTemplateCodes(@RequestParam(name = "templateCodes") List<String> templateCodes);

    /**
     * 根据模板消息给用户
     *
     * @return
     */
    @PutMapping("/api/operation/msg/template/sendTemplateMsgToUser")
    Response sendTemplateMsgToUser(@RequestBody OperateMsgTemplateDto msgTemplateDto);
    // =========  end of message 模块   ===========

    // =========  start of  推荐码管理 by liangyongtong   ===========

    /**
     * 查询列表信息
     *
     * @param iiuvCode 推荐码 精准匹配
     * @param iiuvName 推荐名称 模糊匹配
     * @param iiuvType 推荐类型
     * @param page     当前页
     * @param limit    每页条数
     * @return 查询列表
     */
    @GetMapping("api/operation/iiuv/queryPage")
    PageTable<OperateIiuv> operateIiuvPageTable(@RequestParam(value = "iiuvCode", required = false) String iiuvCode,
                                                @RequestParam(value = "iiuvName", required = false) String iiuvName,
                                                @RequestParam(value = "iiuvType", required = false) String iiuvType,
                                                @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 查询推荐码管理列表
     *
     * @param reqParam
     * @return
     */
    @PostMapping("/api/operation/iiuv/list/queryPage")
    PageTable<OperateIiuv> operateIiuvListPageTable(@RequestBody IiuvReqParam reqParam);

    /**
     * 添加推荐码
     *
     * @param iiuv 推荐码数据
     * @return
     */
    @PostMapping("api/operation/iiuv/save")
    Response operateIiuvSave(@RequestBody OperateIiuv iiuv);

    /**
     * 添加推荐码
     *
     * @param iiuv 推荐码数据
     * @return
     */
    @PostMapping("/api/operation/iiuv/saveByStoreCode")
    Response<String> operateIiuvSaveByStoreCode(@RequestParam("storeCode") String storeCode,
                                                @RequestParam("storeName") String storeName,
                                                @RequestParam("type") String type,
                                                @RequestBody UserTimeEntity entity);

    /**
     * 创建推荐码
     *
     * @param dto
     * @return
     */
    @PostMapping("/api/operation/iiuv/createIiuv")
    Response<String> createIiuv(@RequestBody CreateIiuvDTO dto);

    /**
     * 根据推荐删除数据
     *
     * @param iiuvCode 推荐码
     * @return
     */
    @GetMapping("api/operation/iiuv/deleteByCode")
    Response operateIiuvDeleteByCode(@RequestParam(value = "iiuvCode") String iiuvCode);

    /**
     * 更新推荐二维码
     *
     * @param iiuv 推荐注册信息
     * @return
     */
    @PostMapping("api/operation/iiuv/genrate")
    Response operateIiuvGenrate(@RequestBody OperateIiuv iiuv);

    /**
     * 批量更新推荐二维码
     *
     * @param iiuvs 推荐注册信息
     * @return
     */
    @PostMapping("api/operation/iiuv/batchGenrate")
    Response operateIiuvBatchGenrate(@RequestBody List<OperateIiuv> iiuvs);

    /**
     * 通过编码数组查询推荐码信息
     *
     * @param iiuvCodes 推荐码数组
     * @return
     */
    @GetMapping("api/operation/iiuv/operateIiuvListByCodes")
    Response<List<OperateIiuv>> operateIiuvListByCodes(@RequestParam(value = "iiuvCodes") String[] iiuvCodes);

    /**
     * 获取推荐码详情
     *
     * @param iiuvCode 推荐码
     * @return
     */
    @GetMapping("api/operation/iiuv/detailByCode")
    Response<OperateIiuv> operateIiuvDetail(@RequestParam(value = "iiuvCode") String iiuvCode);
    // =========  end of  推荐码管理 by liangyongtong   ===========

    // =========  start of  小程序二维码生成配置 by liangyongtong   ===========

    /**
     * 根据类型获取小程序生成配置信息
     *
     * @param type 类型
     * @return
     */
    @GetMapping("api/operation/qrconfig/getByType")
    Response<OperateQrConfig> operateQrConfigByType(@RequestParam(value = "type") String type);

    /**
     * 通过编码获取对应的跳转配置
     *
     * @param code 编码
     * @return
     */
    @GetMapping("api/operation/qrparamer/getbycode")
    Response<OperateQrParameter> getOperateQrParameterByCode(@RequestParam(value = "code") String code);

    /**
     * 根据跳转路径编码删除数据
     *
     * @param code 跳转路径编码
     * @return
     */
    @GetMapping("api/operation/qrparamer/deleteByCode")
    Response deleteOperateQrParameterByCode(@RequestParam(value = "code") String code);

    /**
     * 查询列表信息
     *
     * @param code  跳转路径编码
     * @param name  跳转路径名称
     * @param type  跳转路径类型
     * @param page  当前页
     * @param limit 每页跳数
     * @return 查询列表
     */
    @GetMapping("api/operation/qrparamer/queryPage")
    PageTable<OperateQrParameter> operateQrParameterPageTable(@RequestParam(value = "code", required = false) String code,
                                                              @RequestParam(value = "name", required = false) String name,
                                                              @RequestParam(value = "type", required = false) String type,
                                                              @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                              @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 保存或更新saveOrUpdateUserQrParameter
     *
     * @param operateQrParameter
     * @return
     */
    @PostMapping("api/operation/qrparamer/saveOrUpdateOperateQrParameter")
    Response saveOrUpdateOperateQrParameter(@RequestBody OperateQrParameter operateQrParameter);

    // =========  end of  小程序二维码生成配置 by liangyongtong   ===========

    // =========  start of  二维码管理 by huhl   ===========

    @GetMapping("api/operation/qr/queryPage")
    PageTable<OperateQr> operateQrPageTable(@RequestParam(value = "qrCode", required = false) String qrCode,
                                            @RequestParam(value = "qrName", required = false) String qrName,
                                            @RequestParam(value = "relationType", required = false) String relationType,
                                            @RequestParam(value = "page", defaultValue = "1") Integer page,
                                            @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    @PostMapping("api/operation/qr/list/queryPage")
    PageTable<OperateQr> operateQrListPageTable(@RequestBody QrReqParam reqParam);

    /**
     * 删除二维码通过二维码编码
     *
     * @param code 二维码编码
     * @return
     */
    @GetMapping("api/operation/qr/deleteByCode")
    Response deleteOperateQrByCode(@RequestParam(value = "code") String code);

    /**
     * 获取二维码详情通过二维码编码
     *
     * @param code
     * @return
     */
    @GetMapping("api/operation/qr/detailByCode")
    Response<OperateQr> operateQrDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 保存二维码数据
     *
     * @param operateQr
     * @return
     */
    @PostMapping("api/operation/qr/saveOperateQr")
    Response saveOperateQr(@RequestBody OperateQr operateQr);

    /**
     * 保存二维码数据
     *
     * @param
     * @return
     */
    @PostMapping("/api/operation/qr/saveOperateQrByStoreCode")
    Response saveOperateQrByStoreCode(@RequestParam("relationCode") String relationCode, @RequestBody OperateQr qr);


    /**
     * 根据二维码编码查询集合
     *
     * @param qrCodes
     * @return
     */
    @GetMapping("api/operation/qr/operateQrListByCode")
    Response<List<OperateQr>> operateQrListByCode(@RequestParam(value = "qrCodes") String[] qrCodes);

    // =========  end of  二维码管理 by huhl   =============

    // ============= start of 返点费率设置 by luoyc==================

    /**
     * 保险公司返点费率列表
     *
     * @param limit
     * @param page
     * @param companyCode
     * @param companyName
     * @param status
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/pageInsuranceCommissionList")
    PageTable<OperateInsuranceCommissionPageDto> pageInsuranceCommissionList(
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page,
            @RequestParam(value = "companyCode", required = false) String companyCode,
            @RequestParam(value = "companyName", required = false) String companyName,
            @RequestParam(value = "status", required = false) String status);

    /**
     * 获取保险公司
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/gainInsuranceCommissionInfo/{code}")
    OperateInsuranceCommission gainInsuranceCommissionInfo(@PathVariable("code") String code);

    @PutMapping("/api/operation/insurance/commission/checkDate")
    Response checkDate(@RequestBody Map<String, Object> map);

    /**
     * 商户端公司费率列表
     *
     * @param companyName
     * @param vciRateOrderBy
     * @param tciRateOrderBy
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/listShopInsuranceCommissionAndSettingList")
    Response<List<OperateInsuranceCommissionShopPageDto>> listShopInsuranceCommissionAndSettingList(
            @RequestParam(value = "companyName", required = false) String companyName,
            @RequestParam(value = "vciRateOrderBy", required = false, defaultValue = "desc") String vciRateOrderBy,
            @RequestParam(value = "tciRateOrderBy", required = false, defaultValue = "desc") String tciRateOrderBy);

    /**
     * 根据公司code 和 费率code 获取信息
     *
     * @param companyCode
     * @param settingCode
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/gainShopInsuranceCommissionInfo/{companyCode}/{settingCode}")
    Response<OperateInsuranceCommissionDto> gainShopInsuranceCommissionInfoAndSetting(@PathVariable("companyCode") String companyCode,
                                                                                      @PathVariable("settingCode") String settingCode);

    /**
     * 启用/停用
     *
     * @param code
     * @param status
     * @return
     */
    @PutMapping("/api/operation/insurance/commission/updateStatus/{code}/{status}")
    Response updateInsuranceCommissionStatus(@PathVariable("code") String code, @PathVariable("status") String status, @RequestParam("updater") String updater);

    /**
     * 新增
     *
     * @param operateInsuranceCommissionDto
     * @return
     */
    @PostMapping("/api/operation/insurance/commission/save")
    Response saveInsuranceCommission(@RequestBody OperateInsuranceCommissionDto operateInsuranceCommissionDto);

    /**
     * 更新
     *
     * @param operateInsuranceCommissionDto
     * @return
     */
    @PostMapping("/api/operation/insurance/commission/update")
    Response updateInsuranceCommission(@RequestBody OperateInsuranceCommissionDto operateInsuranceCommissionDto);

    /**
     * 费率列表
     *
     * @param limit
     * @param page
     * @param oicCode
     * @param companyCode
     * @return
     */
    @GetMapping("/api/operation/insurance/rebate/rate/pageRebateRateSettingList")
    PageTable<OperateRebateRateSetting> pageRebateRateSettingList(
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page,
            @RequestParam(value = "oicCode", required = false) String oicCode,
            @RequestParam(value = "companyCode", required = false) String companyCode);

    /**
     * 修改费率设置
     *
     * @param operateRebateRateSetting
     * @return
     */
    @Deprecated
    @PostMapping("/api/operation/insurance/rebate/rate/update")
    Response updateRebateRateSetting(@RequestBody OperateRebateRateSetting operateRebateRateSetting);

    /**
     * 修改状态 未生效->生效->作废、未生效->作废
     *
     * @param code
     * @param status
     * @return
     */
    @Deprecated
    @PutMapping("/api/operation/insurance/rebate/rate/updateStatus/{code}/{status}")
    Response updateRebateRateSettingStatus(@PathVariable("code") String code, @PathVariable("status") String status, @RequestParam("updater") String updater);

    /**
     * 过期费率设置任务
     *
     * @return
     */
    @GetMapping("/api/operation/insurance/rebate/rate/scheduleExpireRebateRateSetting")
    Response<String> scheduleExpireRebateRateSetting();

    /**
     * 操作日志列表
     *
     * @param limit
     * @param page
     * @param oicCode
     * @param companyCode
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/log/pageInsuranceCommissionLogList")
    PageTable<OperateInsuranceCommissionLog> pageInsuranceCommissionLogList(
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page,
            @RequestParam(value = "oicCode", required = false) String oicCode,
            @RequestParam(value = "companyCode", required = false) String companyCode);
    // ============= end of 返点费率设置 by luoyc==================

    @PostMapping("/api/operation/iiuv/gainQrCodesByStoreCodes")
    public Response<Map<String, MerchantStoreQrDto>> gainQrCodesByStoreCodes(@RequestBody List<String> storeCodes);

    @GetMapping("/api/operation/qr/gainQrUrlByStoreCode/{storeCode}")
    public Response<OperateQr> gainQrUrlByStoreCode(@PathVariable("storeCode") String storeCode);

    // ============= start of 意见反馈 by yinshihao==================

    /**
     * 保存意见反馈
     *
     * @return
     */
    @PostMapping("/api/operation/opinion/saveOpinion")
    Response saveOpinion(@RequestBody OperateOpinion opinion);

    /**
     * 根据用户编码和openid获取该用户的意见列表
     *
     * @param userCode
     * @param openid
     * @return
     */
    @GetMapping("/api/operation/opinion/findOpinionsByUserCodeAndOpenid")
    Response<List<OperateOpinion>> findOpinionsByUserCodeAndOpenid(@RequestParam("userCode") String userCode,
                                                                   @RequestParam(value = "openid", required = false) String openid);

    /**
     * 根据意见编码获取意见信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/opinion/getOpinionByCode")
    Response<OperateOpinion> getOpinionByCode(@RequestParam("code") String code);

    /**
     * 后台分页查询用户意见列表
     *
     * @param code
     * @param userCode
     * @param openid
     * @param phone
     * @param source
     * @param opinionType
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/opinion/findOpinionsPageTable")
    PageTable<OperateOpinion> findOpinionsPageTable(@RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "userCode", required = false) String userCode,
                                                    @RequestParam(value = "openid", required = false) String openid,
                                                    @RequestParam(value = "phone", required = false) String phone,
                                                    @RequestParam(value = "source", required = false) String source,
                                                    @RequestParam(value = "opinionType", required = false) String opinionType,
                                                    @RequestParam(value = "createTimeStart", required = false) String createTimeStart,
                                                    @RequestParam(value = "createTimeEnd", required = false) String createTimeEnd,
                                                    @RequestParam(value = "miniAppid", required = false) String miniAppid,
                                                    @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                    @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 后台导出用户意见列表
     *
     * @param code
     * @param userCode
     * @param openid
     * @param phone
     * @param source
     * @param opinionType
     * @param createTimeStart
     * @param createTimeEnd
     * @return
     */
    @GetMapping("/api/operation/opinion/findOpinionsList")
    Response<List<OperateOpinion>> findOpinionsList(@RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "userCode", required = false) String userCode,
                                                    @RequestParam(value = "openid", required = false) String openid,
                                                    @RequestParam(value = "phone", required = false) String phone,
                                                    @RequestParam(value = "source", required = false) String source,
                                                    @RequestParam(value = "opinionType", required = false) String opinionType,
                                                    @RequestParam(value = "createTimeStart", required = false) String createTimeStart,
                                                    @RequestParam(value = "createTimeEnd", required = false) String createTimeEnd,
                                                    @RequestParam(value = "miniAppid", required = false) String miniAppid);

    // ============= end of 意见反馈 by yinshihao==================

    // ============= start of 返点费率设置 by luoyc==================

    /**
     * 保存二维码扫码历史记录
     *
     * @param operateQrScanHistoryDTO
     * @return
     */
    @PostMapping("/api/operation/qr/history/saveQrHistory")
    Response saveQrHistory(@RequestBody OperateQrScanHistoryDTO operateQrScanHistoryDTO);

    @GetMapping("/api/operation/qr/history/operateQrHistoryPageTable")
    PageTable<OperateQrScanHistory> operateQrHistoryPageTable(@RequestParam(value = "qrCode") String qrCode,
                                                              @RequestParam(value = "userMobile", required = false) String userMobile,
                                                              @RequestParam(value = "wxOpenid", required = false) String wxOpenid,
                                                              @RequestParam(value = "scanTimeStart", required = false) LocalDateTime scanTimeStart,
                                                              @RequestParam(value = "scanTimeEnd", required = false) LocalDateTime scanTimeEnd,
                                                              @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                              @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    // ============= end of 返点费率设置 by luoyc==================

    // ============= start of 代理人二维码 by luoyc==================

    /**
     * 获取代理人推荐码、二维码
     *
     * @param code 当前用户code
     * @return OperateIiuvQrDTO
     */
    @GetMapping("/api/operation/iiuv/getUserAgentIiuvCodeAndQrCode")
    Response<OperateIiuvQrDTO> getUserAgentIiuvCodeAndQrCode(@RequestParam(value = "code") String code);


    /**
     * 根据用户名获取二维码
     *
     * @param username
     * @return
     */
    @GetMapping("/api/operation/iiuv/getQrCodeByUsername")
    Response<OperateIiuvQrDTO> getQrCodeByUsername(@RequestParam(value = "username") String username);

    /**
     * 获取/创建代理人推荐码
     *
     * @param code 当前用户code
     * @return OperateIiuv
     */
    @GetMapping("/api/operation/iiuv/gainOrCreateUserAgentIiuvCode")
    Response<OperateIiuv> gainOrCreateUserAgentIiuvCode(@RequestParam(value = "code") String code, @RequestParam(value = "iiuvName") String iiuvName);
    // ============= end of 代理人二维码 by luoyc==================


    @PostMapping("/api/operation/filter/page/queryPage")
    PageTable<OperateFilterPage> filterPageTable(@RequestBody OperateFilterPage operateFilterPage);

    @PostMapping("/api/operation/filter/page/saveOrUpdate")
    Response filterPageSaveOrUpdate(@RequestBody OperateFilterPage operateFilterPage);

    @GetMapping("/api/operation/filter/page/getByCode/{filterPageCode}")
    Response<OperateFilterPage> filterPageGetByCode(@PathVariable("filterPageCode") String filterPageCode);

    /**
     * 筛选列表
     *
     * @param filterPageCode
     * @return
     */
    @GetMapping("/api/operation/filter/group/filterGroupList")
    Response<List<OperateFilterGroupDto>> filterGroupList(@RequestParam("filterPageCode") String filterPageCode);

    @PostMapping("/api/operation/filter/group/saveOrUpdate")
    Response filterGroupSaveOrUpdate(@RequestBody OperateFilterGroup operateFilterGroup);

    @GetMapping("/api/operation/filter/group/delete/{id}")
    Response filterGroupDelete(@PathVariable("id") Integer id, @RequestParam("createUser") String createUser);

    @GetMapping("/api/operation/filter/group/getById/{id}")
    Response<OperateFilterGroup> filterGroupGetById(@PathVariable("id") Integer id);

    @GetMapping("/api/operation/filter/group/getByFilterPageCode/{filterPageCode}")
    Response<List<OperateFilterGroup>> filterGroupGetByFilterPageCode(@PathVariable("filterPageCode") String filterPageCode);

    @PostMapping("/api/operation/filter/label/saveOrUpdate")
    Response filterLabelSaveOrUpdate(@RequestBody OperateFilterLabel operateFilterLabel);

    @GetMapping("/api/operation/filter/label/delete/{id}")
    Response filterLabelDelete(@PathVariable("id") Integer id);

    @GetMapping("/api/operation/filter/label/getByGroupId/{groupId}")
    Response<List<OperateFilterLabel>> filterLabelGetById(@PathVariable("groupId") Integer groupId);

    @PostMapping("/api/operation/filter/log/queryPage")
    PageTable<OperateFilterLog> filterLogPageTable(@RequestBody OperateFilterLog operateFilterLog);


    // ============= start of 额度申请相关 by zhangmin==================

    /**
     * @param applyCode    申请单编号
     * @param isLoadDetail 是否加载申请单详情，包括：团队信息、审批信息
     */
    @GetMapping("/api/operation/quota/apply/{applyCode}")
    Response<OperateQuotaApply> getQuotaApplyByCode(@PathVariable("applyCode") String applyCode,
                                                    @RequestParam(value = "isLoadDetail", defaultValue = "false") Boolean isLoadDetail);


    /**
     * 最基础的信息 OperateQuotaApply
     * @param applyCode 申请单编号
     * @param isLoadApplyAttach 是否加载 申请附件
     * @return
     */
    @GetMapping("/api/operation/quota/apply/baseInfo/{applyCode}")
    Response<OperateQuotaApply> getQuotaApplyBaseInfoByCode(@PathVariable("applyCode") String applyCode,
                                                              @RequestParam(value = "isLoadDetail", defaultValue = "false") Boolean isLoadApplyAttach);

    /**
     * 按照申请状态统计申请金额，笔数
     *
     * @param applierUser 申请人用户名
     */
    @Deprecated
    @GetMapping("/api/operation/quota/apply/statisByStatus")
    Response<List<QuotaApplyStatisResult>> statisQuotaApplyGroupByStatus(@RequestParam(value = "applierUser", required = false) String applierUser);


    /**
     * 按照申请状态 分组统计申请金额，笔数
     */
    @PostMapping("/api/operation/quota/apply/statisGroupByStatus")
    Response<List<QuotaApplyStatisResult>> statisApplyNumGroupByStatus(@RequestBody WapStatisQuotaApplyGroupByStatusParamDto statisParamDto);


    /**
     * 新增/编辑额度申请,编辑成功后返回申请单号
     */
    @PostMapping("/api/operation/quota/apply/saveUpdate")
    Response<QuotaApplyCurProcessDto> saveUpdateQuotaApply(@RequestBody OperateQuotaApply apply);


    /**
     * 更新额度申请单基本信息
     */
    @PostMapping("/api/operation/quota/apply/basicUpdateApply")
    Response basicUpdateQuotaApply(@RequestBody OperateQuotaApply updateApply);


    //撤回额度申请
    @PostMapping("/api/operation/quota/apply/recall")
    Response<OperateQuotaApply> recallQuotaApply(@RequestBody OperateQuotaApplyProgress recallDto);

    //删除额度申请
    @GetMapping("/api/operation/quota/apply/remove")
    Response removeQuotaApply(@RequestParam("applyCode") String applyCode, @RequestParam("removeUser") String removeUser);

    //作废额度申请
    @PostMapping("/api/operation/quota/apply/invalid")
    Response invalidQuotaApply(@RequestBody OperateQuotaApplyProgress recallDto);

    /**
     * 额度划拨处理操作：审批通过以后，额度和备付金都增加成功以后，将申请单更新为已完成
     *
     * @param applyCode      额度申请单号
     * @param handleUsername 处理申请单的登录用户名
     */
    @PostMapping("/api/operation/quota/apply/handle")
    Response handelQuotaApply(@RequestBody OperateQuotaApplyProgress allocateDto);

    /**
     * 更新划拨划拨操作：关联的交易号
     */
    @PostMapping("/api/operation/quota/apply/updateAllocateTradeNo")
    Response updateAllocateTradeNo(@RequestBody UpdateAllocateTradeNoDto tradeNoDto);

    /**
     * 小程序端搜索 额度申请单
     */
    @PostMapping("/api/operation/quota/apply/weappSearch")
    PageTable<OperateQuotaApply> weappSearchQuotaApply(@RequestBody WapSearchQuotaApplyParamDto wapSearchParam);

    /**
     * 小程序或管理端 搜索我的待办事项：包括 【待我审批/我已审批【待我审核/我已审核】,【待我划拨/我已划拨】页面
     */
    @PostMapping("/api/operation/quota/apply/searchAffairAboutMe")
    PageTable<OperateQuotaApply> searchAffairAboutMe(@RequestBody SearchQuotaApplyAffairParamDto searchAffairParamDto);

    /**
     * 统计我的待办事项 数量 （用来展示左上角标数量）
     * @param loginUserName 登录用户名，即待办事项的人
     * @param loginUserId 登录用户Id
     */
    @GetMapping("/api/operation/quota/apply/statisPendingAffairNum")
    Response<Map<String, Integer>> statisQuotaApplyPendingAffairNum(@RequestParam("loginUserName") String loginUserName, @RequestParam("loginUserId") Integer loginUserId);


    /**
     * admin端搜索 额度申请单
     */
    @PostMapping("/api/operation/quota/apply/adminSearch")
    PageTable<OperateQuotaApply> adminSearchQuotaApply(@RequestBody AdminSearchQuotaApplyParamDto searchParam);

    /**
     * 审批申请
     *
     * @param approveRecord 审批记录
     */
    @PostMapping("/api/operation/quota/approvalApply/approve")
    Response<QuotaApplyCurProcessDto> approveQuotaApply(@RequestBody OperateQuotaApplyApproveRecord approveRecord);

    /**
     * 统计审批人审批的申请
     *
     * @param approverUser 审批人用户名
     * @param approveType  审批业务类型：审核或审批
     */
    @GetMapping("/api/operation/quota/approvalApply/statis")
    Response<Map<ApproveQueryTypeTabEnum, ApprovalStatisResult>> statisApprovalApply(@RequestParam(value = "approverUser") String approverUser,
                                                                                     @RequestParam(value = "approveType") QuotaApproveNodeTypeEnum approveType,
                                                                                     @RequestParam(value = "tradeType",required = false)  String tradeType,
                                                                                     @RequestParam(value = "feeType",required = false)    String feeType);


    /**
     * 小程序搜索 与我相关的审批
     */
    @GetMapping("/api/operation/quota/approvalApply/weappSearch")
    PageTable<OperateQuotaApply> weappSearchApproval(@SpringQueryMap WapSearchQuotaApprovalParamDto searchParam);

    /**
     * 额度申请获取某个审批记录的附件列表
     *
     * @param applyCode
     * @param approveRecordId 审批记录Id
     */
    @GetMapping("/api/operation/quota/approvalApply/getApproveRecordAttach")
    Response<List<OperateQuotaApplyAttach>> getQuotaApproveRecordAttach(@RequestParam("applyCode") String applyCode, @RequestParam("approveRecordId") Integer approveRecordId);

    /**
     * 获得发放主体 审批设置信息
     */
    @GetMapping("/api/operation/quota/configAccount/getSettingInfo")
    Response<ApprovalSettingInfoDto> getQuotaSettingInfo(@RequestParam("issuingBodyCode") String issuingBodyCode);


    /**
     * 只是获取配置主体配置的额度申请模式信息
     * @param issuingBodyCode
     */
    @GetMapping("/api/operation/quota/configAccount/getConfigApplyMode")
    Response<OperateQuotaConfigAccount> getConfigQuotaApplyMode(@RequestParam("issuingBodyCode") String issuingBodyCode);

    /**
     * 设置申请人，审批人信息（保存或编辑配置）
     *
     * @param settingInfo
     */
    @PostMapping("/api/operation/quota/configAccount/saveUpdateSettingInfo")
    Response saveUpdateQuotaSettingInfo(@RequestBody ApprovalSettingInfoDto settingInfo);

    /**
     * 原来是【虚拟额度管理】模式，并选中【主体自己申请】,在分销调整为【备付金模式】时自动更新为选中【运营代申请】,并删除发放主体申请人
     */
    @PostMapping("/api/operation/quota/configAccount/updateToOperatorProxyMode")
    Response updateToOperatorProxyModeAndClearApplier(@RequestBody List<String> issuingBodyCodeList);

    /**
     * 更新额度配置基本信息（例如主体搜索关键词）
     * @param configAccount
     * @return
     */
    @PostMapping("/api/operation/quota/configAccount/updateQuotaConfigAccountBasic")
    Response<OperateQuotaConfigAccount> updateQuotaConfigAccountBasic(@RequestBody OperateQuotaConfigAccount configAccount);


    //申请/审批账号相关接口
    @GetMapping("/api/operation/quota/configAccount/getQuotaAcctType")
    Response<QuoteAcctTypeDto> getQuotaAcctType(@RequestParam("username") String username);

    /**
     * 从传入的用户名列表中过滤出来是审核人或审批人的用户名
     *
     * @param usernameList
     */
    @GetMapping("/api/operation/quota/configAccount/findApproverUsernameList")
    Response<List<String>> findQuotaApproverUsernameList(@RequestParam("usernameList") List<String> usernameList);


    /**
     * 小程序管理端 搜索我能申请的主体
     */
    @GetMapping("/api/operation/quota/configAccount/weappSearchCanApplyIssueBody")
    PageTable<SearchCanApplyIssueBodyRespDto> weappSearchCanApplyIssueBody(@SpringQueryMap SearchCanApplyIssueBodyParamDto searchParam);


    /**
     * 搜索 我能审批/审核的主体
     */
    @GetMapping("/api/operation/quota/configAccount/searchCanApproveIssueBody")
    PageTable<SearchCanApplyIssueBodyRespDto> searchCanApproveIssueBody(@SpringQueryMap SearchCanApproveIssueBodyParamDto searchParam);


    /**
     * 设置系统平台/代理商 审批节点
     *
     * @param settingInfo
     */
    @PostMapping("/api/operation/quota/configBaseNode/saveUpdateConfig")
    Response saveUpdateQuotaBaseConfigNode(@RequestBody List<OperateQuotaBaseConfigNode> config);

    /**
     * 获得系统平台/代理商 审批设置信息
     *
     * @return
     */
    @GetMapping("/api/operation/quota/configBaseNode/getConfig")
    Response<List<OperateQuotaBaseConfigNode>> getQuotaBaseConfigNode(@RequestParam(value = "approverType", defaultValue = "SYSTEM") QuotaApplyNodeApproverTypeEnum approverType,
                                                                      @RequestParam(value = "agentCode", required = false) String agentCode);


    // ============= end of 额度申请相关 by zhangmin==================

    // ============= start of 发放主体短信配置 ==================

    /**
     * 根据发放主体编号查询对应的短信模板
     *
     * @param issuingBodyCode 发放主体编号
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/searchByIssuingBodyCode")
    PageTable<OperateIssuingBodyMessage> searchByIssuingBodyCode(@RequestParam(name = "issuingBodyCode") String issuingBodyCode,
                                                                 @RequestParam(value = "signName", required = false) String signName,
                                                                 @RequestParam(value = "templateTitle", required = false) String templateTitle,
                                                                 @RequestParam(name = "limit", defaultValue = "20") int limit,
                                                                 @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 根据发放主体编号查询对应的短信模板(不分页)
     *
     * @param issuingBodyCode 发放主体编号
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/findByIssuingBodyCode")
    Response<List<OperateIssuingBodyMessage>> findByIssuingBodyCode(@RequestParam(name = "issuingBodyCode") String issuingBodyCode);

    /**
     * 批量保存发放主题短信模板
     *
     * @param messages
     * @return
     */
    @PostMapping("/api/operation/issuingBody/message/batchSave")
    Response batchSaveIssuingBodyMessage(@RequestBody List<OperateIssuingBodyMessage> messages);

    /**
     * 获取发放主体短信模板配置
     *
     * @param id 记录id
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/{id}/get")
    Response<OperateIssuingBodyMessage> getIssuingBodyMessage(@PathVariable(name = "id") Integer id);

    /**
     * 设置默认的短信模板
     *
     * @param id 记录id
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/{id}/default")
    Response setDefaultIssuingBodyMessage(@PathVariable(name = "id") Integer id,
                                          @RequestParam(name = "issuingBodyCode") String issuingBodyCode);

    /**
     * 删除发放主体短信模板
     *
     * @param id 记录id
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/{id}/delete")
    Response deleteIssuingBodyMessage(@PathVariable(name = "id") Integer id);

    /**
     * 设置短信延迟发放时间
     *
     * @param id            记录id
     * @param sendDelayTime 延迟发送时间（分钟）
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/setSendDelayTime")
    Response setIssuingBodyMessageSendDelayTime(@RequestParam(name = "id") Integer id,
                                     @RequestParam(name = "sendDelayTime") Integer sendDelayTime);

    /**
     * 根据发放主体编码查询发放主体默认的短信模板
     *
     * @param issuingBodyCode 发放主体编码
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/getDefaultMessageTemplate")
    Response<String> getIssuingBodyDefaultMessageTemplate(@RequestParam(name = "issuingBodyCode") String issuingBodyCode);

    /**
     * 根据发放主体编码查询发放主体默认的短信模板
     *
     * @param issuingBodyCode 发放主体编码
     * @return
     */
    @GetMapping("/api/operation/issuingBody/message/getDefaultMessageTemplateDetail")
    Response<OperateIssuingBodyMessage> getIssuingBodyDefaultMessageTemplateDetail(@RequestParam(name = "issuingBodyCode") String issuingBodyCode);
    // ============= end of 发放主体短信配置 ==================

    /**
     * 根据服务商获取当前服务商有划拨权限的系统用户
     *
     * @param agentCode 服务商编码
     */
    @GetMapping("/api/operation/agentper")
    PageTable<OperateAgentUsersPermission> searchOperateAgentUsersPermission(@RequestParam(name = "agentCode") String agentCode,
                                                                             @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                                             @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 批量保存划拨权限的系统用户
     *
     * @param listOperateAgentUsersPermissionDto 系统用户跟服务商编码的列表
     */
    @PostMapping("/api/operation/agentper/saveBatch")
    Response<String> saveOperateAgentUsersPermission(@RequestBody List<OperateAgentUsersPermissionDto> listOperateAgentUsersPermissionDto);

    /**
     * 根据指定的编号，删除对应的划拨权限
     *
     * @param agentCode 服务商编码
     * @param userId    用户编号
     */
    @GetMapping("/api/operation/agentper/delete")
    Response<String> deleteOperateAgentUsersPermissionByAgentCodeAndUserId(@RequestParam(name = "agentCode") String agentCode,
                                                                           @RequestParam(name = "userId") Integer userId);

    /**
     * 小程序端根据"服务商编码"和系统用户编号判断是否有划拨额度按钮的权限
     *
     * @param agentCode 服务商编码
     * @param userId    系统用户编号
     */
    @GetMapping("/api/operation/agentper/judgePermission")
    Response<Boolean> judgeOperateAgentUsersPermission(@RequestParam(name = "agentCode", required = false) String agentCode,
                                                       @RequestParam(name = "userId") Integer userId);

    /**
     * 小程序端根据"服务商编码集合"和系统用户编号判断是否有划拨额度按钮的权限
     *
     * @param agentCodeList 服务商编码集合
     * @param userId        系统用户编号
     */
    @GetMapping("/api/operation/agentper/judgePermissionByList")
    Response<Map<String, Boolean>> judgeOperateAgentUsersPermissionByList(@RequestParam(name = "agentCodeList") List<String> agentCodeList,
                                                                          @RequestParam(name = "userId") Integer userId);

    /**
     * 判断系统用户编号是否在任一服务商有划拨权限
     *
     * @param userId 系统用户编号
     */
    @GetMapping("/api/operation/agentper/isHavePermissionById")
    Response<Boolean> isHaveOperateAgentUsersPermissionById(@RequestParam(name = "userId") Integer userId);

    /**
     * 根据服务商编码查询出改服务商下所有有划拨权限的系统人员
     *
     * @param agentCode 服务商编码
     */
    @GetMapping("/api/operation/agentper/allForAgentCode")
    List<OperateAgentUsersPermission> searchOperateAgentUsersPermissionByAgentCode(@RequestParam(name = "agentCode") String agentCode);

    /**
     * 4S店集团-分页查询列表
     * @param params 入参实体
     * @return 结果列表
     */
    @GetMapping("/api/operation/car/dealer/bloc/page")
    PageTable<OperateCarDealerBloc> operateCarDealerBlocPageSearch(@SpringQueryMap OperateCarDealerBlocDto params);

    /**
     * 根据唯一编码查询实体对象
     * @param code 唯一编码
     * @return 结果实体
     */
    @GetMapping("/api/operation/car/dealer/bloc/getByCode")
    Response<OperateCarDealerBloc> operateCarDealerBlocGetByCode(@RequestParam("code") String code);

    /**
     * 4S店集团-更新或保存实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/bloc/saveOrUpdate")
    Response<OperateCarDealerBloc> operateCarDealerBlocSaveOrUpdate(@RequestBody OperateCarDealerBloc data);

    /**
     * 4S店集团-删除实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/bloc/delete")
    Response<?> operateCarDealerBlocDelete(@RequestBody OperateCarDealerBloc data);

    /**
     * 4S店-分页查询列表
     * @param params 入参实体
     * @return 结果列表
     */
    @GetMapping("/api/operation/car/dealer/shop/page")
    PageTable<OperateCarDealerShop> operateCarDealerShopPageSearch(@SpringQueryMap OperateCarDealerShopDto params);

    /**
     * 根据唯一编码查询实体对象
     * @param code 唯一编码
     * @return 结果实体
     */
    @GetMapping("/api/operation/car/dealer/shop/getByCode")
    Response<OperateCarDealerShop> operateCarDealerShopGetByCode(@RequestParam("code") String code);

    /**
     * 4S店-更新或保存实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/shop/saveOrUpdate")
    Response<OperateCarDealerShop> operateCarDealerShopSaveOrUpdate(@RequestBody OperateCarDealerShop data);

    /**
     * 4S店-删除实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/shop/delete")
    Response<?> operateCarDealerShopDelete(@RequestBody OperateCarDealerShop data);

    /**
     * 合同管理-分页查询列表
     * @param params 入参实体
     * @return 结果列表
     */
    @PostMapping("/api/operation/car/dealer/contract/page")
    PageTable<OperateCarDealerContract> operateCarDealerContractPageSearch(@RequestBody OperateCarDealerContractDto params);

    /**
     * 合同管理-根据唯一编码查询实体对象
     * @param code 唯一编码
     * @return 结果实体
     */
    @GetMapping("/api/operation/car/dealer/contract/getByCode")
    Response<OperateCarDealerContract> operateCarDealerContractGetByCode(@RequestParam("code") String code);

    /**
     * 合同管理-更新或保存实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/contract/saveOrUpdate")
    Response<OperateCarDealerContract> operateCarDealerContractSaveOrUpdate(@RequestBody OperateCarDealerContract data);

    /**
     * 合同管理-删除实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/contract/delete")
    Response<?> operateCarDealerContractDelete(@RequestBody OperateCarDealerContract data);

    /**
     * 合同管理-更新归档状态
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/contract/updateArchiveStatus")
    Response<?> operateCarDealerContractUpdateArchiveStatus(@RequestBody OperateCarDealerContract data);

    /**
     * 4S店操作日志-分页查询列表
     * @param params 入参实体
     * @return 结果列表
     */
    @GetMapping("/api/operation/car/dealer/log/page")
    PageTable<OperateCarDealerLog> operateCarDealerLogPageSearch(@SpringQueryMap OperateCarDealerLogDto params);

    /**
     * 根据code查询列表
     * @param code 日志编码
     * @return 结果列表
     */
    @GetMapping("/api/operation/car/dealer/log/listByCode")
    List<OperateCarDealerLog> operateCarDealerLogListByCode(@RequestParam("code") String code);

    /**
     * 更新或保存实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/car/dealer/log/saveLog")
    Response<OperateCarDealerLog> operateCarDealerSaveLog(@RequestBody OperateCarDealerLog data);


    // ============= start of 裂变种子、销售线索、交互动作记录管理 ==================

    /**
     * 分页查询裂变种子
     * @param searchDto
     * @return
     */
    @GetMapping("/api/fission/seed/list")
    PageTable<OperateFissionSeed> selectFissionSeedPage(@SpringQueryMap FissionSeedSearchDto searchDto);

    /**
     * 根据code查看种子详情
     * @param code
     * @return
     */
    @GetMapping("/api/fission/seed/detail/{code}")
    Response<OperateFissionSeed> detailFissionSeedByCode(@PathVariable("code") String code);

    /**
     * 新增或编辑种子
     * @param fissionSeed
     */
    @PostMapping("/api/fission/seed/addOrEdit")
    Response<OperateFissionSeed> addOrEditFissionSeed(@RequestBody OperateFissionSeed fissionSeed);

    /**
     * 根据code删除种子
     * @param code
     */
    @PostMapping("/api/fission/seed/del/{code}")
    Response deleteFissionSeedByCode(@PathVariable("code") String code);

    /**
     * 分页查询种子关系
     * @param searchDto
     * @return
     */
    @GetMapping("/api/fission/relation/list")
    PageTable<FissionRelationRespDto> selectFissionRelationPage(@SpringQueryMap FissionRelationSearchDto searchDto);

    /**
     * 根据上级种子获取其对应的所有下级种子code
     * @param parentCode
     * @return
     */
    @GetMapping("/api/fission/relation/listCode")
    Response<List<String>> getRelationCodeByParentCode(@RequestParam("parentCode") String parentCode);

    /**
     * 根据id查询种子关系详情
     * @param id
     * @return
     */
    @GetMapping("/api/fission/relation/detail/{id}")
    Response<OperateFissionRelation> detailFissionRelationById(@PathVariable("id") Integer id);

    /**
     * 新增或编辑种子关系
     * @param fissionRelation
     * @return
     */
    @PostMapping("/api/fission/relation/addOrEdit")
    Response addOrEditFissionRelation(@RequestBody OperateFissionRelation fissionRelation);

    /**
     * 根据id删除种子关系
     * @param id
     * @return
     */
    @PostMapping("/api/fission/relation/del/{id}")
    Response<OperateFissionRelation> deleteFissionRelationById(@PathVariable("id") Integer id);

    /**
     * 分页查询销售线索
     * @param searchDto
     * @return
     */
    @GetMapping("/api/sale/clew/list")
    PageTable<SaleClewRespDto> selectSaleClewPage(@SpringQueryMap SaleClewSearchDto searchDto);

    /**
     * 根据code查看销售线索详情
     * @param code
     * @return
     */
    @PostMapping("/api/sale/clew/detail/{code}")
    Response<OperateSaleClew> detailSaleClewByCode(@PathVariable("code") String code);

    /**
     * 新增或编辑销售线索
     * @param saleClew
     */
    @PostMapping("/api/sale/clew/addOrEdit")
    Response<OperateSaleClew> addOrEditSaleClew(@RequestBody OperateSaleClew saleClew);

    /**
     * 推进线索
     * @param advance
     * @return
     */
    @PostMapping("/api/sale/clew/advance")
    Response<String> advanceSaleClew(@RequestBody OperateSaleClew advance);

    /**
     * 关闭线索
     * @param off
     * @return
     */
    @PostMapping("/api/sale/clew/off")
    Response<String> offSaleClew(@RequestBody OperateSaleClew off);

    /**
     * 暂停推进/恢复推进线索
     * @param saleClew
     * @return
     */
    @PostMapping("/api/sale/clew/updateAdvanceStatus")
    Response<String> updateSaleClewAdvanceStatus(@RequestBody OperateSaleClew saleClew);

    /**
     * 根据code删除销售线索
     * @param code
     */
    @PostMapping("/api/sale/clew/del/{code}")
    Response deleteSaleClewByCode(@PathVariable("code") String code);

    /**
     * 分页查询交互动作记录
     * @param searchDto
     * @return
     */
    @GetMapping("/api/interactive/record/list")
    PageTable<InteractiveRecordRespDto> selectInteractiveRecordPage(@SpringQueryMap InteractiveRecordSearchDto searchDto);

    /**
     * 根据code查看交互动作记录详情
     * @param code
     * @return
     */
    @PostMapping("/api/interactive/record/detail/{code}")
    Response<OperateInteractiveRecord> detailInteractiveRecordByCode(@PathVariable("code") String code);

    /**
     * 新增或编辑交互动作记录
     * @param record
     */
    @PostMapping("/api/interactive/record/addOrEdit")
    Response<OperateInteractiveRecord> addOrEditInteractiveRecord(@RequestBody OperateInteractiveRecord record);

    /**
     * 根据code删除交互动作记录
     * @param code
     */
    @PostMapping("/api/interactive/record/del/{code}")
    Response deleteInteractiveRecordByCode(@PathVariable("code") String code);


    /**
     * 运营标签-分页查询列表
     * @param params 入参实体
     * @return 结果列表
     */
    @GetMapping("/api/operation/label/page")
    PageTable<OperateLabel> operateLabelPageSearch(@SpringQueryMap OperateLabelDto params);

    /**
     * 根据唯一编码查询实体对象
     * @param code 唯一编码
     * @return 结果实体
     */
    @GetMapping("/api/operation/label/getByCode")
    Response<OperateLabel> operateLabelGetByCode(@RequestParam("code") String code);

    /**
     * 运营标签-更新或保存实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/label/saveOrUpdate")
    Response<OperateLabel> operateLabelSaveOrUpdate(@RequestBody OperateLabel data);

    /**
     * 运营标签-删除实体
     * @param data  实体对象
     */
    @PostMapping("/api/operation/label/delete")
    Response<?> operateLabelDelete(@RequestBody OperateLabel data);

    /**
     * 运营标签-贴标签
     * @param data  实体对象
     */
    @PostMapping("/api/operation/label/saveLabels")
    Response<?> operateLabelSaveLabels(@RequestBody OperateSaveLabelDto data);

    // ============= end of 裂变种子、销售线索、交互动作记录管理 ==================





    /**-------------------  调查问券 相关方法 start  ----------- **/

    /**
     * 获取调查问券详细信息：包括配置信息，题目
     * @param inverstCode 调查问券编号
     */
    @GetMapping("/api/operate/inverst/getConfigByCode")
    Response<OperateInverstConfig> getInverstConfigByCode(@RequestParam("inverstCode") String inverstCode);

    /**
     * 获取调查问券基本信息
     * @param inverstCode 调查问券编号
     */
    @GetMapping("/api/operate/inverst/getConfigBasicByCode")
    Response<OperateInverstConfig> getInverstConfigBasicInfoByCode(@RequestParam("inverstCode") String inverstCode);

    /**
     * 删除问券调查,如果删除成功，则返回被删除的问券对象
     * @param inverstCode 调查问券编号
     */
    @GetMapping("/api/operate/inverst/removeByInverstCode")
    Response<OperateInverstConfig> removeInverstConfigByInverstCode(@RequestParam("inverstCode") String inverstCode);

    /**
     * 修改问券状态，例如：上/下操作
     */
    @PostMapping("/api/operate/inverst/changeStatus")
    Response changeInverstConfigStatusByInverstCode(@RequestBody InverstConfigUpdateStatusDto updateStatusDto);

    /**
     * 通过问券编号 更新 问券基本配置信息
     * @param config
     */
    @PostMapping("/api/operate/inverst/updateBasic")
    Response updateInverstConfigBasicInfo(@RequestBody OperateInverstConfig config);


    /**
     * 会员答题，保存提交调查问券结果
     * @param inverstPaper
     *
     * @return 返回答题试券编号
     */
    @PostMapping("/api/operate/inverstPaper/submit")
    Response submitInverstPaper(@RequestBody OperateInverstPaper inverstPaper);


    /**
     * 搜索用户提交的 调查问券提交记录
     */
    @PostMapping("/api/operate/inverstPaper/search")
    PageTable<OperateInverstPaper> searchInverstPaperPage(@RequestBody InverstPaperSearchParamDto searchParam);


    /**
     * 获取某个调查问券 考试答题券详情
     */
    @GetMapping("/api/operate/inverstPaper/getDetail")
    Response<OperateInverstPaper> getInverstPaperByPaperCode(@RequestParam("paperCode") String paperCode);


    /**
     * 搜索分页 问题配置项
     */
    @PostMapping("/api/operate/inverst/search")
    PageTable<OperateInverstConfig> searchInverstConfigPage(@RequestBody InverstConfgSearchParamDto searchParam);

    /**
     * 保存或者更新问券
     * @return
     */
    @PostMapping("/api/operate/inverst/saveOrUpdateInverstConfig")
    Response saveOrUpdateInverstConfig(@RequestBody OperateInverstConfig req);

    /**-------------------  调查问券 相关方法 end  ----------- **/




    /**-------------------  提现问券 相关方法 start  ----------- **/

    /**
     * 提现问券,保存答题结果
     * @param withdrawPaper
     *
     * @return 返回答题试券编号
     */
    @PostMapping("/api/operate/withdrawInverstPaper/submit")
    Response submitWithdrawInverstPaper(@RequestBody OperateInverstWithdrawPaper withdrawPaper);


    /**
     * 搜索提现问券 调查问券提交记录
     */
    @PostMapping("/api/operate/withdrawInverstPaper/search")
    PageTable<OperateInverstWithdrawPaper> searchWithdrawInverstPaperPage(@RequestBody WithdrawPaperSearchParamDto searchParam);


    /**
     * 获取某个提现问券 考试答题券详情
     */
    @GetMapping("/api/operate/withdrawInverstPaper/getDetail")
    Response<OperateInverstWithdrawPaper> getWithdrawInverstPaperByPaperCode(@RequestParam("paperCode") String paperCode);


    /**
     * 获取提现问券信息,用来同步提送到题库中心
     * @param paperCode 问券编号
     */
    @GetMapping("/api/operate/withdrawInverstPaper/getDetailForPush")
    Response<InverstWithdrawPaperSaveReqDto> getWithdrawPaperForPushByPaperCode(@RequestParam("paperCode") String paperCode);


    /**
     * 定时任务：每隔6分钟尝试，重试推送失败的问券（问券推送到题库系统）
     */
    @GetMapping("/api/operate/withdrawInverstPaper/retryFindFailPaperForPush")
    Response<List<OperateInverstWithdrawPaper>> retryFindFailWithdrawPaperForPush(@RequestParam(value = "fetchSize",required = false,defaultValue = "500") Integer fetchSize,
                                                                                  @RequestParam(value = "maxId",required = false) Integer maxId);

    /**
     * 更新提现问券的同步状态
     */
    @PostMapping("/api/operate/withdrawInverstPaper/update")
    Response updateWithdrawInverstPaper(@RequestBody OperateInverstWithdrawPaper withdrawPaper);

    /**-------------------  提现问券 相关方法 end  ----------- **/

    /**
     * 供应商结算分页查询
     * @return
     */
    @PostMapping("/api/operate/settle/distribution/pageSettleQuery")
    PageTable<SettleDistribution> pageSettleQuery(@RequestBody SettleDistributionReq req);

    /**
     * 供应商结算明细分页查询
     * @return
     */
    @GetMapping("/api/operate/settle/distribution/pageSettleDetailQuery")
    PageTable<SettleDistributionDetail> pageSettleDetailQuery(@RequestParam("settleDistributionNo") String settleDistributionNo,
                                                              @RequestParam(required = false, value = "excludeIds") List<Integer> excludeIds,
                                                              @RequestParam(defaultValue = "1", value = "page") int page,
                                                              @RequestParam(defaultValue = "10", value = "limit") int limit);

    /**
     * 供应商冲抵明细分页查询
     * @return
     */
    @GetMapping("/api/operate/settle/distribution/pageSettleReturnDetailQuery")
    PageTable<SettleDistributionReturnDetail> pageSettleReturnDetailQuery(@RequestParam("settleDistributionNo") String settleDistributionNo,
                                                                          @RequestParam(required = false, value = "excludeIds[]") List<Integer> excludeIds,
                                                                          @RequestParam(defaultValue = "1", value = "page") int page,
                                                                          @RequestParam(defaultValue = "10", value = "limit") int limit);

    /**
     * 供应商结算全部查询
     * @return
     */
    @PostMapping("/api/operate/settle/distribution/queryAllSettle")
    Response<List<SettleDistribution>> queryAllSettle(@RequestBody SettleDistributionReq req);

    /**
     * 供应商结算明细全部查询
     * @return
     */
    @PostMapping("/api/operate/settle/distribution/queryAllSettleDetail")
    Response<List<SettleDistributionDetail>> queryAllSettleDetail(@RequestParam("settleId") Integer settleId);

    /**
     * 供应商冲抵明细全部查询
     * @return
     */
    @PostMapping("/api/operate/settle/distribution/queryAllSettleReturnDetail")
    Response<List<SettleDistributionReturnDetail>> queryAllSettleReturnDetail(@RequestParam("settleId") Integer settleId);

    /**
     * 保存或更新结算单
     * @return
     */
    @PostMapping("/api/operate/settle/distribution/saveOrUpdate")
    Response<SettleDistribution> settleDistributionSaveOrUpdate(@RequestBody SettleDistributionDto dto);

    /**
     * 更新结算单状态
     * @return
     */
    @PostMapping("/api/operate/settle/distribution/updateSettleStatus")
    Response updateSettleStatus(@RequestBody SettleDistributionDto dto);

    /**
     * 定时器更新结算单状态
     * @return
     */
    @GetMapping("/api/operate/settle/distribution/updateSettleStatusByParam")
    Response<Map<String,Map<String, Set<Long>>>> updateSettleStatusByParam(@RequestParam("receiveTime") String receiveTime,
                                                                              @RequestParam("billStatus") String billStatus,
                                                                              @RequestParam("detailStatus") String detailStatus,
                                                                              @RequestParam("returnStatus") String returnStatus,
                                                                              @RequestParam(value ="limit", required = false) Integer limit);

    /**
     * 根据id获取结算单
     * @return
     */
    @GetMapping("/api/operate/settle/distribution/queryById")
    Response<SettleDistributionDto> getSettleDistributionById(@RequestParam("id") Integer id);

    /**
     * 根据id删除结算单
     * @return
     */
    @GetMapping("/api/operate/settle/distribution/delSettleDistributionById")
    Response delSettleDistributionById(@RequestParam("id") Integer id);

    /**
     * 提交校验
     * @return
     */
    @GetMapping("/api/operate/settle/distribution/dataCheck")
    Response dataCheck(@RequestParam("id") Integer id, @RequestParam("status") String status);

    /**
     * 结算操作日志-分页查询列表
     * @param params 入参实体
     * @return 结果列表
     */
    @GetMapping("/api/operate/settle/distribution/log/page")
    PageTable<SettleDistributionLog> settleDistributionLogPageSearch(@SpringQueryMap SettleDistributionLogDto params);

    /**
     * 根据code查询列表
     * @param code 日志编码
     * @return 结果列表
     */
    @GetMapping("/api/operate/settle/distribution/log/listByCode")
    List<SettleDistributionLog> settleDistributionLogListByCode(@RequestParam("code") String code);


    /**
     * 更新或保存实体
     * @param data  实体对象
     */
    @PostMapping("/api/operate/settle/distribution/log/saveLog")
    Response<SettleDistributionLog> settleDistributionSaveLog(@RequestBody SettleDistributionLog data);
}
