package com.rocogz.syy.operation.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.operation.entity.OperateInsuranceCommission;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class OperateInsuranceCommissionShopPageDto {

    /**
     * OperateInsuranceCommission表
     * 编码（表唯一字段，相当于主键功效）
     */
    private String code;

    /**
     * 保险公司代码（唯一）
     */
    private String companyCode;

    /**
     * 保险公司名称（唯一）
     */
    private String companyName;

    /**
     * Setting表
     * 费率编号（表唯一字段，相当于主键功效）
     */
    private String settingCode;

    /**
     * 商业险费率
     */
    private BigDecimal vciRate;

    /**
     * 交强险费率
     */
    private BigDecimal tciRate;

    /**
     * 页面显示的标识（第一页，商业险费率降序排序前三条）
     */
    private int topMark;

}
