package com.rocogz.syy.operation.dto.car.dealer;

import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * @Description: 销售线索查询dto
 * @date：2022/12/9
 * @author：huangdeyi
 */
@Data
public class SaleClewSearchDto {

    /**
     * 编号
     */
    private String code;

    /**
     * 来源种子code
     */
    private String fissionSeedCode;

    /**
     * 来源种子姓名
     */
    private String fissionSeedName;

    /**
     * 来源种子手机号
     */
    private String fissionSeedMobile;

    /**
     * 线索4S店集团
     */
    private String blocCode;

    /**
     * 线索4S店
     */
    private String shopCode;

    /**
     * 关键人姓名
     */
    private String keyPersonName;

    /**
     * 关键人手机号
     */
    private String keyPersonMobile;

    /**
     * 线索提供年份
     */
    private String clewOfferYear;

    /**
     * 线索提供月份
     */
    private List<String> clewOfferMonth;

    /**
     * 线索提供开始日期
     */
    private String clewOfferStartDate;

    /**
     * 线索提供结束日期
     */
    private String clewOfferEndDate;

    /**
     * 转化成功开始日期
     */
    private String conversionSuccessStartDate;

    /**
     * 转化成功结束日期
     */
    private String conversionSuccessEndDate;

    /**
     * 登记开始日期
     */
    private String createTimeStartDate;

    /**
     * 登记结束日期
     */
    private String createTimeEndDate;

    /**
     * 推进人姓名
     */
    private String promoterName;

    /**
     * 推进人手机号
     */
    private String promoterMobile;

    /**
     * 线索阶段
     */
    private String clewStage;

    /**
     * 线索策略
     */
    private String clewStrategy;

    /**
     * 线索推进情况
     */
    private String clewAdvanceStatus;

    /**
     * 线索转换情况
     */
    private String clewConversionStatus;

    /**
     * 当前页
     */
    private int page;

    /**
     * 每页记录数
     */
    private int limit;
}
