package com.rocogz.syy.operation.dto.quotapply;


import com.rocogz.syy.operation.constants.OperationConstant;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

@Setter @Getter
public abstract class BaseSearchQuotaApplyDto {

    /**
     * 申请单状态
     * @see OperationConstant.DictQuotaApplyStatus
     */
    private String status;

    /**
     * 查询的发放主体账号列表
     */
    private List<String> issuingBodyCodeList;

    /**
     * 服务商编号列表
     */
    private List<String> agentCodeList;

    /**
     * 合作客户的 【数据权限中客户编号】
     */
    private List<String> customerCodeList;

    /**
     * 额度申请的交易类型
     * @see OperationConstant.DictQuotaTradeType#QUOTA_APPLY
     */
    private String tradeType;

    /**
     * 调整的业务类型
     * @see OperationConstant.DictQuotaAdjustType#ADD
     */
    private String adjustType;

    /**
     * 额度费用类型
     * @see OperationConstant.DictQuotaApplyFeeType#UNIVERSAL_USE
     */
    private String feeType;


    private int limit = 20;

    private int page = 1;

}
