package com.rocogz.syy.operation.entity.quotapply;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.QuotaApplyNodeApproverTypeEnum;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * 审批节点基类
 * @author zhangmin
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class BaseQuotaNode extends IdEntity {

    /**
     * 如果主体不设置任何审批节点，则虚拟一个审批节点
     */
    public static final String VIRTUAL_NODE_CODE = "VIRND1001";

    /**
     * 审批节点编号
     */
    private String nodeCode;

    /**
     * 审批节点名称
     */
    private String nodeName;

    /**
     * 节点业务类型：审核或审批
     */
    private QuotaApproveNodeTypeEnum nodeType;

    /**
     * 审批人账号类型
     */
    private QuotaApplyNodeApproverTypeEnum approverType;

    /**
     * 审批节点顺序
     */
    private Integer seq;


    public String getNodeTypeLabel() {
        return this.getNodeType().getLabel();
    }

    public String getApproverTypeLabel() {
        return this.getApproverType().getLabel();
    }

}
