package com.rocogz.syy.operation.dto.inverst;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 提现问题选项
 * * 这个在interface中 查询问问卷结果 也用了它作为接受 返回值
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperateWithdrawQuestOptionDto {

    /**
     * 问题编号
     */
    private String questionCode;

    /**
     * 选项编号
     */
    private String optCode;

    /**
     * 选择题的选项/标签Tag
     */
    private String opt;

    /**
     * 选项索引号，用来展示选择题A，B，C等
     */
    private Integer seq;


    /**
     * 用户是否选择该选项，勾选了，则为true
     */
    private Boolean checked;


    /**
     * 获取选项 字母：例如：A,B,C
     */
    public String getOptLetter() {
        if (seq == null) {
            return StringUtils.EMPTY;
        }
        //seq 从 1开始
        char letter = (char) (64 + seq);
        return String.valueOf(letter);
    }


}
