package com.rocogz.syy.operation.dto.quotapply;

import com.rocogz.syy.operation.constants.OperationConstant;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 小程序端搜索 额度申请单 查询参数
 * @author zhangmin
 */
@Setter @Getter
public class WapSearchQuotaApplyParamDto extends WapStatisQuotaApplyGroupByStatusParamDto {

    /**
     * 申请单状态
     * @see OperationConstant.DictQuotaApplyStatus
     */
    private String status;

    /**
     * 申请单状态列表
     * @see OperationConstant.DictQuotaApplyStatus
     */
    private List<String> statusList;

    /**
     * 申请人名称关键词  模糊匹配
     */
    private String keyword;


    /**
     * keyword关键词 在equity_issuing_body 主体简称 中 匹配出来的主体编号列表
     */
    private List<String> keywordBodyCodeList;


    /**
     * 额度申请的 额度调整类型【交易类型是额度申请】
     * @see OperationConstant.DictQuotaAdjustType#ADD
     */
    private String adjustType;

    private String startTime;

    private String endTime;


    private Integer limit = 20;

    private Integer page = 1;


    public WapSearchQuotaApplyParamDto() {
        this.setLimit(10);
    }

    public String getKeywordLike() {
        keyword = StringUtils.trimAllWhitespace(keyword);

        if (StringUtils.isEmpty(keyword)) {
            return null;
        }
        return "%" + keyword + "%";
    }

}
