package com.rocogz.syy.operation.entity.filter;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 运营服务-筛选页定制管理表
 * </p>
 *
 * @author luoyc
 * @since 2021-01-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("operate_filter_page")
public class OperateFilterPage extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 页面编号
     */
    private String filterPageCode;

    /**
     * 页面名称
     */
    private String filterPageName;

    /**
     * 条件组名称
     */
    private String filterGroupName;

    /**
     * 条件组数量
     */
    private Integer filterGroupNum;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态
     */
    private String status;

    /**
     * 使用状态
     */
    private String useStatus;

    /**
     * 服务平台编码
     */
    private String servicePlatformCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 操作项
     */
    @TableField(exist = false)
    private String operate;

    /**
     * 变更信息
     */
    @TableField(exist = false)
    private String remarkLog;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer size = 10;
}
