package com.rocogz.syy.operation.dto.inverst;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.operation.entity.inverst.OperateInverstConfigQuestion;
import com.rocogz.syy.operation.enums.InverstQuestTypeEnum;
import com.rocogz.syy.operation.enums.InvestRateTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangmin
 * 提交的考券的 题目
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperateExamQuestDto {

    /**
     * 问题编号
     */
    private String questCode;

    /**
     * 问题题型
     */
    private InverstQuestTypeEnum questType;

    /**
     * 问题题干
     */
    private String questTitle;

    /**
     * 题目顺序号
     */
    private Integer questSeq;

    /**
     * 是否必答题
     */
    private Boolean mustAnswer;

    /**
     * 题目评分：NPS评分最小值 【评分类型题目 专有字段】
     */
    private Integer rateMin;

    /**
     * 题目评分：NPS评分最大值 【评分类型题目 专有字段】
     */
    private Integer rateMax;


    /**
     * 评分题：用户选择的答案：评分
     */
    private Integer selectedRate;

    /**
     * 只有配置了 评分便签问题,并且用户选择了评分数，才知道 本次评分结果类型
     * 本次评分结果类型：算正面评分，还是负面评分
     *
     * @see OperateInverstConfigQuestion#rateConfigure
     */
    private InvestRateTypeEnum rateResultType;

    /**
     * 问答题：用户回答的答案
     */
    private String answer;


    private List<OperateExamQuestOptionDto> optionList;


    /**
     * 导出的答案，问券详情，答题历史导出功能,导出的答案
     *
     * @return
     */
    public String getRenderAnswer() {
        String empty = "";
        if(questType==null) {
            return empty;
        }
        switch (questType) {
            case RATE:
                return selectedRate == null ? empty : String.valueOf(selectedRate);
            case ASK_ANSWER:
                return answer == null ? empty : answer;
            case TAG:
                return StringUtils.collectionToCommaDelimitedString(getCheckedOptions());
        }
        return empty;
    }

    //获取用户勾选的 选项Tag列表
    public List<String> getCheckedOptions() {
        if(CollectionUtils.isEmpty(optionList)) {
            return Collections.emptyList();
        }
        return optionList.stream().filter(option -> Boolean.TRUE.equals(option.getChecked()))
                .map(OperateExamQuestOptionDto::getOpt).collect(Collectors.toList());
    }

}
