package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 返点费率设置表
 *
 * @author luoyc
 * @since 2020-08-26
 */
@Data
@Accessors(chain = true)
@TableName("operate_rebate_rate_setting")
public class OperateRebateRateSetting extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 费率编号
     */
    private String code;

    /**
     * 保险佣点编码
     */
    private String oicCode;

    /**
     * 保险公司代码
     */
    private String companyCode;

    /**
     * 商业险费率
     */
    private BigDecimal vciRate;

    /**
     * 交强险费率
     */
    private BigDecimal tciRate;

    /**
     * 开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    /**
     * 结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    /**
     * 状态（未生效 INEFFECTIVE, 生效 EFFECTIVE, 过期 EXPIRED, 作废 INVALID）
     */
    private String status;

    /**
     * 创建人账号
     */
    private String createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    /**
     * 更新人账号
     */
    private String updateUser;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
}
