package com.rocogz.syy.operation.entity.inverst;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.InverstQuestTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 调查问券配置题目
 * </p>
 *
 * @author zhangmin
 * @since 2023-01-04
 */
@Setter
@Getter
@Accessors(chain = true)
public class OperateInverstConfigQuestion extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 问题编号
     */
    private String questCode;

    /**
     * 问券编号
     *
     * @see OperateInverstConfig#inverstCode
     */
    private String inverstCode;


    /**
     * 问题题型
     */
    private InverstQuestTypeEnum questType;

    /**
     * 问题题干
     */
    private String questTitle;

    /**
     * 是否必答题
     */
    private Boolean mustAnswer;

    /**
     * 题目顺序号
     */
    private Integer questSeq;

    /**
     * NPS评分最小值 【评分类型题目 专有字段】
     */
    private Integer rateMin;

    /**
     * NPS评分最大值 【评分类型题目 专有字段】
     */
    private Integer rateMax;

    /**
     * 是否配置评分便签问题 【评分类型题目 专有字段】
     */
    private Boolean rateConfigure;

    /**
     * 正面评分值最小值  【评分TAG题目 专有字段】
     */
    private Integer positiveRateMin;

    /**
     * 正面评分值最大值 【评分TAG题目 专有字段】
     */
    private Integer positiveRateMax;

    /**
     * 负面评分值最小值 【评分TAG题目 专有字段】
     */
    private Integer negetiveRateMin;

    /**
     * 负面评分值最大值 【评分TAG题目 专有字段】
     */
    private Integer negetiveRateMax;

    /**
     * 父题编号
     */
    private String parentQuestCode;


    //=== 下面是非持久化字段

    //如果是RATE 题型题目，并且配置了评分便签问题
    @TableField(exist = false)
    private List<OperateInverstConfigQuestion> subQuestList;

    //选择题选项
    @TableField(exist = false)
    private List<OperateInverstQuestOption> optionList;


    //正面评分标签
    @TableField(exist = false)
    private List<OperateInverstQuestOption> positiveTagList;

    //负面评分标签
    @TableField(exist = false)
    private List<OperateInverstQuestOption> negetiveTagList;


}
