package com.rocogz.syy.operation.entity.label;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 运营标签关系表
 * </p>
 * @author 陈煜敏
 * @since 2023-02-15
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("operate_label_relation")
public class OperateLabelRelation extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 标签类型，4S店：4SD，裂变种子：FISSION_SEED
     * @see OperationConstant.OperateLabelType
     */
    private String type;

    /**
     * 标签编码
     */
    private String labelCode;

    /**
     * 目标编码
     */
    private String targetCode;

}
