package com.rocogz.syy.operation.enums;

import lombok.Getter;

/**
 * 额度申请模式
 * @author zhangmin
 */
@Getter
public enum QuotaApplyModeEnum {

    /**
     * 1. 操作入口端：仅可由配置的系统账号进行申请
     *  （1）管理端小程序： 支持的额度管理模式：VIRTUAL_MODE(虚拟额度管理) , RESERVE_PAYMENT("备付金管理")
     *  （2）admin端申请： 支持的额度管理模式：VIRTUAL_MODE(虚拟额度管理) , RESERVE_PAYMENT("备付金管理")
     */
    OPERATOR_PROXY("运营代申请"),   //适配的额度管理模式包括： VIRTUAL_MODE("虚拟额度管理"), RESERVE_PAYMENT("备付金管理")


    /**
     * 1. 操作的入口端：
     * （1）B端小程序： 仅可由配置的主体账号进行申请；  可选额度管理模式仅：VIRTUAL_MODE("虚拟额度管理")
     * （2）admin端申请：仅可由配置的主体账号进行申请； 可选额度管理模式仅：VIRTUAL_MODE("虚拟额度管理")
     */
    ISSUING_BODY_SELF("主体自己申请"); // 适配的额度管理模式 仅 VIRTUAL_MODE("虚拟额度管理")

    private String label;

    QuotaApplyModeEnum(String label) {
        this.label = label;
    }
}
