package com.rocogz.syy.operation.constants;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;

/**
 * 运营中心基础服务，常量类
 *
 * @author zhangmin
 * @date 2020/4/3
 */
public class OperationConstant {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String MIN_TIME_SUFFIX = " 00:00:01";
    public static final String MAX_TIME_SUFFIX = " 23:59:59";

    /**
     * 运营中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "operation-base-service";

    /**
     * 操作额度申请 锁
     */
    public static final String QUOTA_APPLY_OP_LOCK_PREFIX = "QUOTA_APPLY_OP_LOCK_PREFIX:";


    public static class DictData {
        /**
         * 普通消息
         */
        public final static String MESSAGE = "MESSAGE";
        /**
         * 短信消息
         */
        public final static String SMS = "SMS";
        /**
         * 注册推荐码类型
         */
        public static final String REGISTER_IIUV_TYPE = "REGISTER_IIUV_TYPE";
        /**
         * 推荐码商户类型
         */
        public static final String REGISTER_IIUV_TYPE_MD = "MD";
        /**
         * 推荐码个人类型
         */
        public static final String REGISTER_IIUV_TYPE_SP = "SP";

        /**
         * 通用的是
         */
        public static final String COMMON_YES = "Y";
        /**
         * 通用的否
         */
        public static final String COMMON_NO = "N";

        /**
         * 注册推荐码 小程序配置信息
         */
        public static final String IIUV = "IIUV";
    }

    public static class DataStatus {
        /**
         * status 正常状态
         */
        public static final String NORMAL = "NORMAL";
        /**
         * status 锁定状态
         */
        public static final String LOCK = "LOCK";
    }

    /**
     * 审批结果
     */
    public static class DictApproveResult {

        //审核通过
        public static String PASS = "PASS";

        //审核不通过
        public static String FAILED = "FAILED";
    }

    //审核的业务回调状态
    public static class ApproveCallBackStatus {

        //成功
        public static String CALLBACK_SUCCESS = "SUCCESS";

        //失败
        public static String CALLBACK_FAIL = "FAIL";
    }

    //需要审核的业务模块
    public static class ApproveBusinessType {

        //字典类型编号
        public static String TYPE_CODE = "approveBusiness";

        //商品模块
        public static String MERCHANT = "merchant";

        //订单模块
        public static String SALE_ORDER = "saleOrder";

        //订单模块
        public static String GOODS = "goods";

        //推广模块
        public static String POPULARIZE_APPLY = "popularizeApply";
    }

    //审批->商品模块->需要审核的项目
    public static class ApproveMerchantItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.MERCHANT;

        //商户模块下的 门店上架 审核项目编号
        public static String STORE_LIST = "STORE_LIST";
        public static String STORE_DELIST = "STORE_DELIST";

        // 商户模块下的 商品上架  审核项目编号
        public static String GOODS_LIST = "GOODS_LIST";
    }

    //审批->销售订单模块->需要审核的项目
    public static class ApproveSaleOrderItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.SALE_ORDER;
        // 提现订单审核
        public static String WITHDRAWALS_APPROVE = "WITHDRAWALS_APPROVE";

        //下面是订单模块的 审核项目编号

    }

    //审批->推广模块->需要审核的项目
    public static class ApprovePopularizeApplyItems {
        // 推广申请审核
        public static String POPULARIZE_APPLY_APPROVE = "POPULARIZE_APPLY_APPROVE";
    }


    //栏目服务
    public static class ColumnService {

        //服务分类
        public static String SERVICE_TYPE = "SERVICE";
    }


    /**
     * 二维码关联的 推荐码/跳转路径 标示类型
     */
    public static class DictOperateQrRelationType {

        /**
         * 推荐码标示
         */
        public final static String TYPE_IIUV = "IIUV";

        /**
         * 跳转路径标示
         */
        public final static String TYPE_JUMP = "JUMP";


    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /**
         * 意见反馈编号
         */
        public final static String OPINION_TYPE = "OPINION_TYPE";
        /**
         * 系统信息编码
         */
        public final static String SYSTEM_MESSAGE_CODE = "SYSTEM_MESSAGE_CODE";
    }

    /**
     * 附件类型
     */
    public class AttechmentType {
        /**
         * 意见反馈类型
         */
        public final static String OPINION_TYPE = "OPINION_TYPE";
        /**
         * 合同类型
         */
        public final static String CONTRACT_TYPE = "CONTRACT_TYPE";
    }

    /**
     * 意见反馈来源值
     */
    public class OpinionSource {
        /**
         * 车主端
         */
        public final static String CAR = "CAR";
        /**
         * 商户端
         */
        public final static String BUSINESS = "BUSINESS";
        /**
         * 商城端
         */
        public final static String ROCO_MALL = "ROCO_MALL";
        /**
         * 代理人端
         */
        public final static String AGENT = "AGENT";
        /**
         * 权益配置管理系统端
         */
        public final static String EQUITY_MANAGER = "EQUITY_MANAGER";
    }

    /**
     * 运营中心字典类型
     */
    public class DictType {
        /**
         * 消息模板类型
         */
        public final static String OPERATE_MSG_TEMPLATE_TYPE = "OPERATE_MSG_TEMPLATE_TYPE";
        /**
         * 意见来源'
         */
        public final static String OPINION_SOURCE = "OPINION_SOURCE";
        /**
         * 意见类型
         */
        public final static String OPINION_TYPE = "OPINION_TYPE";
    }

    /**
     * 运营中心redisKey前缀
     */
    public class RedisKeyPrefix {
        /**
         * 意见次数
         */
        public final static String OPINION_NUM = "OPINION_NUM:";
    }

    /**
     * 首页版本推荐类型
     */
    public class recommendType {
        /**
         * 商户
         */
        public final static String MERCHANT = "MERCHANT";
        /**
         * 商品
         */
        public final static String GOODS = "GOODS";
        /**
         * 推荐油站端
         */
        public final static String OIL = "OIL";
    }

    /**
     * 系统端分类
     */
    public class systemEnd {
        /**
         * 车主端
         */
        public final static String CAR = "CAR";
        /**
         * 代理人端
         */
        public final static String AGENT = "AGENT";
    }


    /**
     * 栏目分类
     */
    public static class Classify {

        //首页栏目
        public static String INDEX = "INDEX";

        //积分栏目
        public static String POINTS = "POINTS";
    }


    /**
     * 客户权益管理-> 额度申请-> 额度申请方式
     */
    public static class DictQuotaApplyWay {

        //字典类型编号
        public static final String TYPE_CODE = "QUOTA_APPLY_WAY";

        //整体申请
        public static final String ALL = "ALL";

        //分团队申请
        public static final String TEAM = "TEAM";

        //分主体申请
        public static final String ISSUING_BODY = "ISSUING_BODY";
    }


    /**
     * 客户权益管理-> 额度申请-> 申请的额度费用类型
     */
    public static class DictQuotaApplyFeeType {

        //字典类型编号 使用的字典值中的费用字典类型
        public static final String TYPE_CODE = "FEE_TYPE";

        //费用类型：通用费用
        public static final String UNIVERSAL_USE = "UNIVERSAL_USE";

        //费用类型：专用费用 （例如：浙商银行分行专用额度费用）
        public static final String SPECIAL_USE = "SPECIAL_USE";
    }


    /**
     * 额度申请-> 申请端入口
     */
    public static class DictQuotaApplyPortal {
        //字典类型编号
        public static final String TYPE_CODE = "QUOTA_APPLY_PORTAL";

        //B端礼赠程序
        public static final String B_WEAPP = "B_WEAPP";

        //管理端小程序
        public static final String MANAGE_WEAPP = "MANAGE_WEAPP";

        //PC管理后台
        public static final String ADMIN = "ADMIN";
    }


    /**
     * 额度申请->额度申请模式
     */
    public static class DictQuotaApplyMode {

        //字典类型编号
        public static final String TYPE_CODE = "EQUITY_ISSUING_BODY_QUOTA_APPLY_MODE_TYPE";

        //运营代申请
        public static final String OPERATOR_PROXY = "OPERATOR_PROXY";

        //主体自己申请
        public static final String ISSUING_BODY_SELF = "ISSUING_BODY_SELF";


    }


    /**
     * 客户权益管理-> 额度申请-> 额度申请状态
     */
    public static class DictQuotaApplyStatus {
        //字典类型编号
        public static String TYPE_CODE = "QUOTA_APPLY_STATUS";

        // (1)自己创建的，刚提交申请但是未被审批过的申请单，可自己撤回,撤回后,状态变成 草稿
        // (2)第一次保存申请，并设置为草稿状态，即保存草稿 操作
        //(3) 草稿状态时，申请人可以编辑申请单，再次提交申请
        public static final String DRAFT = "DRAFT";

        //【草稿】状态的申请单可由申请人自己作废,作废后，状态变成 "已作废"
        public static final String INVALID = "INVALID";

        //待审核
        public static final String PENDING_AUDIT = "PENDING_AUDIT";

        //待审批
        public static final String PENDING_APPROVE = "PENDING_APPROVE";

        //待划拨
        public static final String PENDING_ALLOCATE = "PENDING_ALLOCATE";

        //划拨处理中
        public static final String PROCESSING = "PROCESSING";

        //已划拨
        public static final String FINISHED = "FINISHED";

        //审核不通过
        public static final String AUDIT_FAILED = "AUDIT_FAILED";

        //审批不通过
        public static final String APPROVE_FAILED = "APPROVE_FAILED";
    }


    /**
     * 客户权益管理-> 额度申请-> 额度申请状态
     */
    public static class DictQuotaApplyFrozenStatus {
        //字典类型编号
        public static String TYPE_CODE = "QUOTA_APPLY_FROZEN_QUOTA_STATUS";

        /**
         * 待冻结
         */
        public static final String PENDING_FROZEN = "PENDING_FROZEN";

        /**
         * 冻结失败
         */
        public static final String FROZEN_FAIL = "FROZEN_FAIL";


        //已冻结
        public static final String FROZEN = "FROZEN";


        //审批不通过，已解冻
        public static final String BACK_UN_FROZENED = "BACK_UN_FROZENED";


        //划拨操作 已解冻
        public static final String HANDLE_UN_FROZENED = "HANDLE_UN_FROZENED";

    }


    /**
     * 客户权益管理-> 额度申请-> 额度申请单的 申请交易类型 （即：申请类型）
     */
    public static class DictQuotaTradeType {

        //字典类型编号
        public static String TYPE_CODE = "QUOTA_APPLY_TRADE_TYPE";

        /**
         * 额度申请：
         * 1. 给申请主体的 主体额度账户增加额度
         * （1）给申请主体的 主体额度账户增加额度 （如果是顶级主体）
         * （2）给顶级主体的主体额度账户增加额度，然后逐级划拨给当前主体\
         * 2.给备付金账户 增加 可用备付金余额
         * 3.申请审批通过后，要根据handleMode(额度划拨模式)配置，是自动划拨，还是手工划拨
         */
        public static final String QUOTA_APPLY = "QUOTA_APPLY";

        // ====下面2种是 分配额度，分配额度：划拨、收回2种

        /**
         * 划拨额度 申请：（只能从父->子 ,不能从爷->孙）
         * (1）划拨额度：从上级主体额度账户 划拨额度 给当前账户的额度账户 （操作的都是主体额度账户，不是个人额度账户）
         * (2)如果当前主体是顶级主体，则不能操作 划拨额度功能
         * (3) 申请审批通过后，自动划拨额度,无需手工再操作
         */
        public static final String ALLOCATE = "ALLOCATE";

        /**
         * 收回额度 申请：（只能 从子->父 ,不能从 孙->爷）
         * (1）收回额度：从当前主体额度账户 收回额度 给父主体额度账户 （操作的都是主体额度账户，不是个人额度账户）
         * (2) 如果当前主体是顶级主体，则不能操作 收回额度功能
         * (3) 申请审批通过后，自动执行收回额度,无需手工再操作
         */
        public static final String ALLOCATE_BACK = "ALLOCATE_BACK";


        public static String getTradeTypeName(String tradeType) {
            String defaultTradeTypeName = "额度申请";

            if (StringUtils.isBlank(tradeType)) {
                return defaultTradeTypeName;
            }

            switch (tradeType) {
                case OperationConstant.DictQuotaTradeType.QUOTA_APPLY:
                    return defaultTradeTypeName;
                case OperationConstant.DictQuotaTradeType.ALLOCATE:
                    return "划拨额度申请";
                case OperationConstant.DictQuotaTradeType.ALLOCATE_BACK:
                    return "收回额度申请";
            }

            return defaultTradeTypeName;
        }

    }


    /**
     * 客户权益管理-> 额度申请-> 额度调整业务类型类型
     */
    public static class DictQuotaAdjustType {

        //字典类型编号
        public static String TYPE_CODE = "QUOTA_APPLY_ADJUST_TYPE";

        /**
         * 额度申请 -> 增加额度
         */
        public static final String ADD = "ADD";

        /**
         * 额度申请-> 减少额度
         * 额度管理模式是 备付金模式 不能 创建减少额度申请
         */
        public static final String REDUCE = "REDUCE";

        /**
         * 分配额度-> 划拨额度
         */
        public static final String ALLOCATE = "ALLOCATE";

        /**
         * 分配额度-> 收回额度
         */
        public static final String ALLOCATE_BACK = "ALLOCATE_BACK";


        public static String getAdjustTypeLabel(String adjustType) {

            String adjustTypeLabel = "额度调整";

            if (StringUtils.isBlank(adjustType)) {
                return adjustTypeLabel;
            }


            switch (adjustType) {
                case OperationConstant.DictQuotaAdjustType.ADD:
                    return "增加额度";
                case OperationConstant.DictQuotaAdjustType.REDUCE:
                    return "减少额度";
                case OperationConstant.DictQuotaAdjustType.ALLOCATE:
                    return "划拨额度";
                case OperationConstant.DictQuotaAdjustType.ALLOCATE_BACK:
                    return "收回额度";
            }

            return adjustTypeLabel;
        }
    }


    /**
     * 客户权益管理-> 额度申请-> 额度划拨模式，即：业务类型是额度申请时，审批通过后请单的处理模式
     */
    public static class DictQuotaApplyHandleMode {

        //字典类型编号
        public static String TYPE_CODE = "QUOTA_APPLY_HANDLE_MODE";

        /**
         * 额度划拨模式： 需平台手工划拨,  申请单审批通过后 需要管理员登录系统 手工划拨
         */
        public static final String MANUAL_HANDLE = "MANUAL_HANDLE";

        /**
         * 额度划拨模式：审批通过后自动划拨, 申请单审批通过后，自动划拨
         */
        public static final String AUTO_HANDLE = "AUTO_HANDLE";
    }


    /**
     * 销售线索推进情况、转化情况
     */
    public static class SaleClew {

        /**
         * 线索阶段字典类型type code
         */
        public static final String CLEW_STAGE_DICT_TYPE_CODE = "CLEW_STAGE";

        /**
         * 线索策略字典类型type code
         */
        public static final String CLEW_STRATEGY_DICT_TYPE_CODE = "CLEW_STRATEGY";

        /**
         * 线索推进情况字典类型type code
         */
        public static final String ADVANCE_STATUS_DICT_TYPE_CODE = "CLEW_ADVANCE_STATUS_TYPE";

        /**
         * 线索推进情况-未开始
         */
        public static final String ADVANCE_STATUS_NOT_START = "NOT_START";

        /**
         * 线索推进情况-推进中
         */
        public static final String ADVANCE_STATUS_IN_PROGRESS = "IN_PROGRESS";

        /**
         * 线索推进情况-已暂停
         */
        public static final String ADVANCE_STATUS_PAUSE = "PAUSE";

        /**
         * 线索推进情况-已关闭
         */
        public static final String ADVANCE_STATUS_OFF = "OFF";

        /**
         * 线索转换情况字典类型type code
         */
        public static final String CONVERSION_STATUS_DICT_TYPE_CODE = "CLEW_CONVERSION_STATUS_TYPE";

        /**
         * 线索转换情况-未开始
         */
        public static final String CONVERSION_STATUS_NOT_START = "NOT_START";

        /**
         * 线索转换情况-推进中
         */
        public static final String CONVERSION_STATUS_IN_PROGRESS = "IN_PROGRESS";

        /**
         * 线索转换情况-转化成功
         */
        public static final String CONVERSION_STATUS_CONVERSION_SUCCESS = "CONVERSION_SUCCESS";

        /**
         * 线索转换情况-转化失败
         */
        public static final String CONVERSION_STATUS_CONVERSION_FAil = "CONVERSION_FAil";
    }

    public static class InterActiveRecord {

        /**
         * 交互类型字典类型type code
         */
        public static final String INTERACTIVE_TYPE_DICT_TYPE_CODE = "INTERACTIVE_TYPE";

        /**
         * 交互所属阶段字典类型type code
         */
        public static final String INTERACTIVE_STAGE_DICT_TYPE_CODE = "INTERACTIVE_STAGE_TYPE";
    }

    public static class FissionSeed {

        /**
         * 种子类型type code
         */
        public static final String SEED_TYPE_DICT_TYPE_CODE = "SEED_TYPE";
    }

    public static class FissionSeedRelation {

        /**
         * 种子关系类型type code
         */
        public static final String SEED_RELATION_DICT_TYPE_CODE = "SEED_RELATION_TYPE";
    }


    /**
     * 配置的 调查问券状态
     */
    public static final class DictInverstStatus {

        public static final String TYPE_CODE = "OPERATE_INVESTIGATION_STATUS";

        /**
         * 已上架
         */
        public final static String UP_LIST = "UP_LIST";

        /**
         * 已下架
         */
        public final static String DOWN_LIST = "DOWN_LIST";
    }


    /**
     * 提现问券：答题券 同步推送状态
     */
    public static class DictWithdrawInverstPaperSyncStatus {
        //字典类型编号
        public static String TYPE_CODE = "WITHDRAW_INVERST_PAPER_SYNC_STATUS";

        //待同步
        public static final String PENDING = "PENDING";

        //同步成功
        public static final String SUCCESS = "SUCCESS";

        //同步失败
        public static final String FAILED = "FAILED";
    }


    /**
     * 合同协议管理-协议状态
     */
    public static class OperateCarDealerContractStatus {
        //字典类型编号
        public static String TYPE_CODE = "OPERATE_CAR_DEALER_CONTRACT_STATUS";

        //未生效
        public static final String NOT_ACTIVE = "NOT_ACTIVE";

        //已生效
        public static final String IN_ACTIVE = "IN_ACTIVE";

        //已失效
        public static final String EXPIRED = "EXPIRED";

    }

    /**
     * 合同协议管理-存档状态
     */
    public static class OperateCarDealerContractArchiveStatus {
        //字典类型编号
        public static String TYPE_CODE = "OPERATE_CAR_DEALER_CONTRACT_ARCHIVE_STATUS";

        //未存档
        public static final String DEFAULT = "DEFAULT";

        //已存档
        public static final String ARCHIVE = "ARCHIVE";

    }

    /**
     * 运营标签-类型
     */
    public static class OperateLabelType {

        //4S店
        public static final String TYPE_4SD = "4SD";

        //裂变种子
        public static final String TYPE_FISSION_SEED = "FISSION_SEED";

    }

    /**
     * 客户权益管理-> 额度申请-> 额度申请状态
     */
    public static class DictTemplateProperties {

        public static String TYPE_CODE = "TEMPLATE_PROPERTIES";

        //系统模板
        public static final String SYSTEM_TEMPLATE = "SYSTEM_TEMPLATE";

        //平台模板
        public static final String PLATFORM_TEMPLATE = "PLATFORM_TEMPLATE";

    }


}
