package com.rocogz.syy.operation.dto.car.dealer;

import lombok.Data;

import java.util.List;


/**
 * @Description: 裂变种子查询dto
 * @date：2022/12/8
 * @author：huangdeyi
 */
@Data
public class FissionSeedSearchDto {

    /**
     * 编号
     */
    private String code;

    /**
     * 排除的编号
     */
    private List<String> excludeCodes;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 性别（常量：MALE-男、FEMALE-女）
     */
    private String gender;

    /**
     * 所属4S店集团code
     */
    private List<String> blocCode;

    /**
     * 所属4S店code
     */
    private List<String> shopCode;

    /**
     * 登记开始时间
     */
    private String createStartTime;

    /**
     * 登记结束时间
     */
    private String createEndTime;

    /**
     * 工作地省编码
     */
    private String workProvinceCode;

    /**
     * 工作地城市编码
     */
    private String workCityCode;

    /**
     * 工作地区县编码
     */
    private String workDistrictCode;

    /**
     * 种子类型
     */
    private String seedType;

    /**
     * 标签code列表
     */
    private List<String> labelCodes;

    /**
     * 当前页
     */
    private int page;

    /**
     * 每页记录数
     */
    private int limit;
}
