package com.rocogz.syy.operation.dto.inverst;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 提交答卷到第三方系统的请求
 * 这个在interface中 保存答卷用到
 * </dd>
 * <dd>@date: 2023/03/21</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InverstWithdrawPaperSaveReqDto {

    /**
     * 答题券编号，就是考试券编号  要加个唯一索引
     */
    private String paperCode;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 提现订单
     */
    private String orderCode;


    /**
     * 答题人会员编号
     */
    private String userCode;

    /**
     * 答题人手机号
     */
    private String userMobile;

    /**
     * 答题人openId
     */
    private String userOpenid;

    /**
     * 姓名
     */
    private String userFullName;

    /**
     * 车牌号
     */
    private String carLicence;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 题目数量
     */
    private Integer questNum;

    /**
     * 问券总分值
     */
    private Integer totalRate;

    /**
     * 提现到账金额
     */
    private BigDecimal rewardAmt;


    /**
     * 问券答题提交试券时间
     */
    private LocalDateTime submitTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 问券答题详情json
     */
    private String paperDetail;

}
