package com.rocogz.syy.operation.dto.inverst;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.operation.entity.inverst.OperateInverstConfigQuestion;
import com.rocogz.syy.operation.enums.InverstQuestTypeEnum;
import com.rocogz.syy.operation.enums.InvestRateTypeEnum;
import com.rocogz.syy.operation.enums.WithdrawQuestTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangmin
 * 提现问券 题目
 *
 * 这个在interface中 查询问问卷结果 也用了它作为接受 返回值
 *
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperateWithdrawQuestDto {
    /**
     * 问题编号
     */
    private String questCode;


    /**
     * 行业类型:例如 保险公司/4s店
     */
    private String industryType;


    /**
     * 问题类型：售后服务/基础信息
     */
    private String questClass;

    /**
     * 问题题型
     */
    private WithdrawQuestTypeEnum questType;

    /**
     * 问题题干
     */
    private String questTitle;

    /**
     * 是否必答题
     */
    private Boolean mustAnswer;

    /**
     * 分值
     */
    private Integer rate;

    /**
     * 题目顺序号
     */
    private Integer questSeq;

    /**
     * 问题选项
     */
    private List<OperateWithdrawQuestOptionDto> optionList;

}
